Name: libpng16
Version: 1.6.36
Release: alt1

Summary: A library of functions for manipulating PNG image format files
License: PNGv2
Group: System/Libraries
Url: http://www.libpng.org/pub/png/

Provides: libpng = %version
Conflicts: libpng15 < 1.5.28-alt2

# git://git.altlinux.org/gears/l/%name.git
Source: %name-%version-%release.tar

BuildRequires: zlib-devel

%package -n libpng-devel
Summary: PNG development library
Group: Development/C
Requires: libpng16 = %version-%release, zlib-devel
Conflicts: libpng15-devel
Conflicts: libpng12-devel

%description
libpng is a library implementing an interface for reading and writing
PNG (Portable Network Graphics) format files.

This package contains the runtime library files needed to run software
using libpng.

%description -n libpng-devel
libpng is a library implementing an interface for reading and writing
PNG (Portable Network Graphics) format files.

This package contains the header and development files needed to build
programs and packages using libpng.

%prep
%setup

%build
%ifarch aarch64
%add_optflags -DPNG_ARM_NEON_OPT=0
%endif
%autoreconf
%configure --disable-static
%make_build

%install
%makeinstall_std
rm %buildroot%_libdir/lib*.la

%define docdir %_docdir/libpng-%version
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
install -p -m644 CHANGES LICENSE README TODO example.c libpng*.txt \
	%buildroot%docdir/
xz -9 %buildroot%docdir/*.txt %buildroot%docdir/CHANGES

%check
%make_build -k check VERBOSE=1

%files
%_libdir/*.so.*
%_man5dir/*
%dir %docdir
%docdir/[CLR]*

%files -n libpng-devel
%_bindir/*-config
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%_man3dir/*
%docdir
%exclude %docdir/[CLR]*

%changelog
