# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/dot /usr/bin/doxygen /usr/bin/xmlto boost-devel-headers
# END SourceDeps(oneline)
Group: System/Libraries
%add_optflags %optflags_shared
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

Name:           libpqxx
Summary:        C++ client API for PostgreSQL
Epoch:          1
Version:        4.0.1
Release:        alt2_13

License:        BSD
URL:            http://pqxx.org/
Source0:        http://pqxx.org/download/software/libpqxx/libpqxx-%{version}.tar.gz
Source1:        http://pqxx.org/download/software/libpqxx/libpqxx-%{version}.tar.gz.md5sum

Patch3:         libpqxx-2.6.8-multilib.patch
Patch4:         libpqxx_configure.patch

BuildRequires:  gcc-c++
BuildRequires:  libecpg-devel libpq-devel postgresql-devel
BuildRequires:  python
Source44: import.info

%description
C++ client API for PostgreSQL. The standard front-end (in the sense of
"language binding") for writing C++ programs that use PostgreSQL.
Supersedes older libpq++ interface.

%package devel
Group: Development/C
Summary:        Development tools for %{name} 
Requires:       %{name} = %{epoch}:%{version}-%{release}
%description devel
%{summary}.

%package doc
Group: System/Libraries
Summary: Developer documentation for %{name}
BuildArch: noarch
%description doc
%{summary}.


%prep
%setup -q

# fix spurious permissions
chmod -x COPYING

%patch3 -p1 -b .multilib
%patch4 -p1


%build
%configure \
  --enable-shared --disable-static

%make_build


%install
%makeinstall_std

rm -fv %{buildroot}%{_libdir}/lib*.la


%check 
# FIXME: most/all fail, need already-running postgresql instance?
%make_build check ||:




%files
%doc AUTHORS ChangeLog NEWS README VERSION
%doc --no-dereference COPYING
%{_libdir}/libpqxx-4.0.so

%files devel
%doc README-UPGRADE
%{_bindir}/pqxx-config
%{_includedir}/pqxx/
%{_libdir}/libpqxx.so
%{_libdir}/pkgconfig/libpqxx.pc

%files doc
%doc doc/html/*


%changelog
