# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl rpm-build-python3 rpm-build-ruby
BuildRequires: /usr/bin/perl libruby-devel lua-devel perl(DynaLoader.pm) perl(Exporter.pm) perl(base.pm) perl(overload.pm) perl-podlators
# END SourceDeps(oneline)
BuildRequires: libltdl7-devel
Group: System/Libraries
%add_optflags %optflags_shared
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global major                   28
%global cppmajor                8

# Notes about rpmlint
# - crypto-policy-non-compliance-gnutls-{1,2} fixed with patch
#   libprelude-5.0.0-gnutls_priority_set_direct.patch

Name:           libprelude
Version:        5.0.0
Release:        alt2
Summary:        Secure Connections between all Sensors and the Prelude Manager
# Prelude is GPL-2.0+
# libmissing is LGPL-2.1+
License:        GPLv2+
URL:            https://www.prelude-siem.org/
Source0:        https://www.prelude-siem.org/pkg/src/%{version}/%{name}-%{version}.tar.gz
# https://www.prelude-siem.org/issues/860
Patch0:         libprelude-5.0.0-ruby_vendorarchdir.patch
# https://www.prelude-siem.org/issues/862
Patch1:         libprelude-5.0.0-gnutls_priority_set_direct.patch
# https://www.prelude-siem.org/issues/863
Patch2:         libprelude-5.0.0-fsf_address.patch
# https://www.prelude-siem.org/issues/865
Patch3:         libprelude-5.0.0-fix_timegm.patch
# https://www.prelude-siem.org/issues/885
Patch4:         libprelude-5.0.0-fix_pthread_atfork.patch
# https://www.prelude-siem.org/issues/887
Patch5:         libprelude-5.0.0-fix_prelude_tests_timer.patch
Patch6:         libprelude-5.0.0-disable_gnulib_test_lock.patch
BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:  bison
BuildRequires:  chrpath
BuildRequires:  flex
BuildRequires:  gtk-doc gtk-doc-mkpdf
BuildRequires:  glib2-devel libgio libgio-devel
BuildRequires:  swig
BuildRequires:  libgpg-error-devel
BuildRequires:  libltdl7-devel
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  python3-devel
BuildRequires:  pkgconfig(gnutls)
BuildRequires:  pkgconfig(lua) >= 5.2
BuildRequires:  pkgconfig(ruby)
BuildRequires:  pkgconfig(zlib)

%ifnarch s390 ppc64 ppc64le
BuildRequires:  valgrind
%endif

# Upstream do not use explicit version of gnulib, just checkout
# and update files. In libprelude 5.0.0, the checkout has been done
# on 2018-09-03
Provides:       bundled(gnulib) = 20180903
Source44: import.info
Patch33: libprelude-1.0.0-alt-extern-libltdl.patch

%description
Libprelude is a collection of generic functions providing communication
between all Sensors, like IDS (Intrusion Detection System), and the Prelude
Manager. It provides a convenient interface for sending and receiving IDMEF
(Information and Event Message Exchange Format) alerts to Prelude Manager with
transparent SSL, fail-over and replication support, asynchronous events and
timer interfaces, an abstracted configuration API (hooking at the command-line,
the configuration line, or wide configuration, available from the Manager), and
a generic plugin API. It allows you to easily turn your favorite security
program into a Prelude sensor.

%description -l ru_RU.UTF-8
Библиотека Prelude содержит коллекцию общих функций, обеспечивающих
коммуникацию между компонентами Prelude Hybrid IDS. Она обеспечивает
интерфейс для пересылки предупреждений менеджеру Prelude используя
SSL, отказоустойчивость и поддержку репликаций, асинхронные события и
интерфейсы таймера, абстрактный конфигурационный API и общий API для
дополнений. Это позволит вам легко интегрировать вашу программу
безопасности в датчик Prelude.

%description -l uk_UA.UTF-8
Бібліотека Prelude містить колекцію спільних функцій, що забезпечують
комунікацію між компонентами Prelude Hybrid IDS. Вона забезпечує
інтерфейс для надсилання попереджень менеджеру Prelude використовуючи
SSL, відмовостійкість і підтримку реплікацій, асинхронні події та
інтерфейси таймера, абстрактний конфігураційний API та загальний API
для доповнень. Це дозволить вам легко інтегрувати вашу програму
безпеки в датчик Prelude.

%package devel
Group: Development/C
Summary:        Libraries and headers for developing Prelude sensors
Requires:       %{name} = %{version}-%{release}
Requires:       pkgconfig(gnutls)
Provides:       prelude-devel = %{version}-%{release}

%description devel
Libraries and headers you can use to develop Prelude sensors using the Prelude
Library. Libprelude is a collection of generic functions providing
communication between all Sensors, like IDS (Intrusion Detection System),
and the Prelude Manager. It provides a convenient interface for sending and
receiving IDMEF (Information and Event Message Exchange Format) alerts to
Prelude Manager with transparent SSL, fail-over and replication support,
asynchronous events and timer interfaces, an abstracted configuration API
(hooking at the command-line, the configuration line, or wide configuration,
available from the Manager), and a generic plugin API. It allows you to easily
turn your favorite security program into a Prelude sensor.

%description -l ru_RU.UTF-8 devel
Библиотеки, заголовочные файлы и т.п вы можете использовать для
разработки датчиков Prelude IDS. Библиотека Prelude содержит коллекцию
общих функций, обеспечивающих коммуникацию между компонентами Prelude
Hybrid IDS. Она обеспечивает интерфейс для пересылки предупреждений
менеджеру Prelude используя SSL, отказоустойчивость и поддержку
репликаций, асинхронные события и интерфейсы таймера, абстрактный
конфигурационный API и общий API для дополнений. Это позволит вам
легко интегрировать вашу программу безопасности в датчик Prelude.

%description -l uk_UA.UTF-8 devel
Бібліотеки, файли заголовків і т.п ви можете використовувати для
розробки датчиків Prelude IDS. Бібліотека Prelude містить колекцію
спільних функцій, що забезпечують комунікацію між компонентами Prelude
Hybrid IDS. Вона забезпечує інтерфейс для надсилання попереджень
менеджеру Prelude використовуючи SSL, відмовостійкість і підтримку
реплікацій, асинхронні події та інтерфейси таймера, абстрактний
конфігураційний API та загальний API для доповнень. Це дозволить вам
легко інтегрувати вашу програму безпеки в датчик Prelude.

%package -n prelude-tools
Group: System/Libraries
Summary:        Command-line tools for %{name}
Requires:       %{name} = %{version}-%{release}

%description -n prelude-tools
Provides a convenient interface for sending alerts to Prelude
Manager.

%package -n python3-module-prelude
Group: System/Libraries
Summary:        Python 3 bindings for prelude
Requires:       %{name} = %{version}-%{release}
%{?python_provide:%python_provide python3-prelude}

%description -n python3-module-prelude
Provides python 3 bindings for prelude.

%package -n perl-prelude
Group: System/Libraries
Summary:        Perl bindings for prelude
Requires:       %{name} = %{version}-%{release}

%description -n perl-prelude
Provides perl bindings for prelude.

%package -n ruby-prelude
Group: System/Libraries
Summary:        Ruby bindings for prelude
Requires:       %{name} = %{version}-%{release}

%description -n ruby-prelude
Provides ruby bindings for prelude.

%package -n lua-prelude
Group: System/Libraries
Summary:        Lua bindings for prelude
Requires:       %{name} = %{version}-%{release}
Requires:       lua5.3

%description -n lua-prelude
Provides Lua bindings for prelude generated by SWIG.

%package doc
Group: System/Libraries
Summary:        Documentation for prelude
BuildArch:      noarch

%description doc
Provides documentation for prelude generated by gtk-doc.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch33 -p0

%build
%autoreconf
%configure \
    --disable-rpath \
    --disable-static \
    --enable-shared \
    --with-swig \
    --without-python2 \
    --with-python3 \
    --with-ruby \
    --with-lua \
    --with-perl-installdirs=vendor \
    --without-included-regex \
    --includedir=%{_includedir}/%{name} \
    --enable-gtk-doc \
    --with-html-dir=%{_docdir}/%{name}-devel
sed -i -e 's! -shared ! -Wl,--as-needed\0!g' libtool
# remove bundled libltld 
rm -fR libltdl
sed -i 's|^\(CFLAGS =.*\)|\1 -include %_includedir/stdio.h|' \
	$(find ./ -name Makefile)

%make_build

%install
%makeinstall_std

chrpath -d %{buildroot}%{_libdir}/*.so.*

find %{buildroot} -name '*.la' -delete
find %{buildroot} -name 'perllocal.pod' -delete
find %{buildroot} -name '.packlist' -delete

# Enable test again after fixing #1629893
#%check
#make check



%files
%{_libdir}/%{name}.so.%{major}
%{_libdir}/%{name}.so.%{major}.*
%{_libdir}/%{name}cpp.so.%{cppmajor}
%{_libdir}/%{name}cpp.so.%{cppmajor}.*
%doc --no-dereference COPYING LICENSE.README HACKING.README
%doc AUTHORS README NEWS

%files devel
%{_datadir}/%{name}
%{_bindir}/%{name}-config
%{_libdir}/%{name}.so
%{_libdir}/%{name}cpp.so
%{_libdir}/pkgconfig/%{name}.pc
%{_includedir}/%{name}
%{_datadir}/aclocal/%{name}.m4
%{_mandir}/man1/%{name}-config.1*

%files -n prelude-tools
# Force default attrs because libprelude force others
%defattr(- , root, root, 755)
%{_bindir}/prelude-adduser
%{_bindir}/prelude-admin
%{_mandir}/man1/prelude-admin.1*
%dir %{_sysconfdir}/prelude
%dir %{_sysconfdir}/prelude/default
%dir %{_sysconfdir}/prelude/profile
%config(noreplace) %{_sysconfdir}/prelude/default/client.conf
%config(noreplace) %{_sysconfdir}/prelude/default/global.conf
%config(noreplace) %{_sysconfdir}/prelude/default/idmef-client.conf
%config(noreplace) %{_sysconfdir}/prelude/default/tls.conf
%dir %{_var}/spool/prelude

%files -n python3-module-prelude
%{python3_sitelibdir}/_prelude.*so
%{python3_sitelibdir}/__pycache__/prelude.cpython-??.*pyc
%{python3_sitelibdir}/prelude-%{version}-py?.?.egg-info
%{python3_sitelibdir}/prelude.py

%files -n perl-prelude
%{perl_vendor_archlib}/Prelude.pm
%dir %{perl_vendor_archlib}/auto/Prelude
# Force attrs because libprelude set it to 555
%attr(755, root, root) %{perl_vendor_archlib}/auto/Prelude/Prelude.so

%files -n ruby-prelude
%{ruby_sitearchdir}/Prelude.so

%files -n lua-prelude
%{_libdir}/lua/*/prelude.so

%files doc
%{_docdir}/%{name}-devel
%doc --no-dereference COPYING LICENSE.README HACKING.README
%doc AUTHORS ChangeLog README NEWS

%changelog
