%define oname libqwt
%define ver_major 6.1
Name: %{oname}6
Version: %ver_major.4
Release: alt1

Summary: 2D plotting widget extension to the Qt GUI

License: LGPL
Group: System/Libraries
Url: http://sourceforge.net/projects/qwt

# https://qwt.svn.sourceforge.net/svnroot/qwt/trunk/qwt
Source: http://sourceforge.net/projects/qwt/files/qwt/%version/qwt-%version.tar.bz2
#Source: qwt-%version.tar
Patch: qwt-6.1.2-qwtconfig.pri.patch

#Provides: %oname = %version-%release
BuildRequires(pre): rpm-macros-qt4
BuildRequires: gcc-c++ libqt4-devel >= 4.4 qt4-designer
BuildRequires: libXext-devel doxygen graphviz
BuildRequires: chrpath

%description
Qwt is an extension to the Qt GUI library from Troll Tech AS.
The Qwt library contains widgets and components which are
primarily useful for technical and scientifical purposes.
It includes a 2-D plotting widget, different kinds of sliders,
and much more.

%package qt4-designer-plugin
Summary: Qwt plugin for qt4-designer
Group: Development/KDE and QT
Requires: %name = %version-%release
Conflicts: %name < %version-%release
Conflicts: %oname %{oname}5_3

%description qt4-designer-plugin
Qwt is an extension to the Qt GUI library from Troll Tech AS.
The Qwt library contains widgets and components which are
primarily useful for technical and scientifical purposes.
It includes a 2-D plotting widget, different kinds of sliders,
and much more.

This package contains Qwt plugin for qt4-designer

%package devel
Summary: Development tools for programs which uses Qwt Widget set
Group: Development/C
#Provides: %oname-devel = %version-%release
Requires: %name = %version-%release
Conflicts: %oname-devel %{oname}5_3-devel

%description devel
The libqwt-devel package contains the header files and libraries
necessary for developing programs using the Qwt Widget set

If you want to develop programs which will use this set of widgets,
you should install this package. You need also to install the libqwt package.

%package devel-doc
Summary: Documentation and examples for Qwt Widget set
Group: Development/Documentation
BuildArch: noarch
Conflicts: %oname-devel-doc %oname-devel %{oname}5_3-devel %{oname}5_3-devel-doc

%description devel-doc
This package contains development documentation and examples for Qwt
Widget set.

%prep
%setup -n qwt-%version
%patch

sed -i "s|/lib|/%_lib|g" qwtconfig.pri
find . -type f -name '*.pro' |while read f; do
echo 'QMAKE_CXXFLAGS += %optflags' >> $f
done

%build
export QTDIR=%_qt4dir
%qmake_qt4 QWT_CONFIG+=QwtMathML
%make_build

pushd doc
doxygen
popd

%install
%make_install install INSTALL_ROOT=%buildroot

install -d %buildroot%_man3dir
install -m644 doc/man/man3/* %buildroot%_man3dir

# clean up the example tree
#(cd examples; make distclean)
#(cd examples; rm -f .*.cache */.*.cache */*/.*.cache)
#(cd examples; rm -rf Makefile */moc */obj */*/moc */*/obj)

chrpath -d %buildroot%_libdir/qt4/plugins/designer/libqwt_designer_plugin.so

%files
%doc README COPYING
%_libdir/libqwt.so.*
%_libdir/libqwtmathml.so.*
%exclude %prefix/doc

%files qt4-designer-plugin
%dir %_qt4dir/plugins/designer
%_qt4dir/plugins/designer/*.so

%files devel
%_includedir/qwt
%_libdir/libqwt.so
%_libdir/libqwtmathml.so

%files devel-doc
%doc doc/html
%doc examples
%_man3dir/*

%changelog
