Name: libsndfile
Version: 1.0.30
Release: alt2

Summary: A library to handle various audio file formats
Group: System/Libraries
License: LGPL
Url: http://www.mega-nerd.com/%name/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

# Was: %url/files/%name-%version.tar.gz
# Now: https://github.com/libsndfile/libsndfile.git
Source: %name-%version.tar

Patch0: libsndfile-1.0.30-system-gsm.patch
Patch1: libsndfile-1.0.25-zerodivfix.patch

BuildRequires: gcc-c++ libalsa-devel libflac-devel libsqlite3-devel libvorbis-devel libgsm-devel
BuildRequires: autogen
BuildRequires: libopus-devel
# for check
BuildRequires: python-modules

%description
%name is a C library for reading and writing sound files such as
AIFF, AU and WAV files through one standard interface. It can currently
read/write 8, 16, 24 and 32-bit PCM files as well as 32-bit floating
point WAV files and a number of compressed formats.

This package contains shared library required for %name-based applications.

%package devel
Summary: Development environment for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains development files required
in development of the %name-based applications.

%package utils
Summary: Utilities for %name
Group: Sound
Requires: %name = %version-%release

%description utils
This package contains utilities for %name

%prep
%setup -q
%patch0 -p2 -b .systemgsm
%patch1 -p1 -b .zerodivfix
rm -r src/GSM610

%build
%autoreconf
%configure \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot \
      htmldir=%_docdir/%name-devel-%version/html install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%make check

%files
%doc AUTHORS NEWS
%_libdir/*.so.*

%files devel
%doc %_docdir/%name-devel-%version
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files utils
%_bindir/*
%_man1dir/*.1*

%changelog
