Name: libssh2
Version: 1.9.0
Release: alt2

Summary: A library implementing the SSH2 protocol
Group: Networking/Remote access
License: BSD
Url: http://www.libssh2.org/
# Git-VCS: https://github.com/libssh2/libssh2.git 
Source: %name-%version.tar

Patch1: CVE-2019-17498.patch

BuildRequires: openssl-devel zlib-devel man

%description
libssh2 is a library implementing the SSH2 protocol as defined by
Internet Drafts: SECSH-TRANS(22), SECSH-USERAUTH(25),
SECSH-CONNECTION(23), SECSH-ARCH(20), SECSH-FILEXFER(06)*,
SECSH-DHGEX(04), and SECSH-NUMBERS(10).

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains libraries and header files for
developing applications that use %name.

%package docs
Summary: Documentation for %name
Group: Development/C
BuildArch: noarch
Requires: %name = %version-%release

%description docs
This package contains manual pages and examples for
developing applications that use %name.

%prep
%setup
%patch1 -p1

%build
# set version
./maketgz %version only
#autoreconf
./buildconf
%configure --disable-static --enable-shared
%make_build

%install
%makeinstall_std

%check
%make_build -k check

%files
%doc docs/AUTHORS README RELEASE-NOTES COPYING
%_libdir/*.so.*

%files docs
%doc docs/BINDINGS docs/HACKING docs/TODO
%_man3dir/*.3*

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%changelog
