%define _unpackaged_files_terminate_build 1
%def_with check

Name: libtalloc
Version: 2.3.2
Release: alt1
Epoch: 1

Summary: The talloc library

License: LGPLv3+
Group: System/Libraries
Url: http://talloc.samba.org/

Source: http://samba.org/ftp/talloc/talloc-%version.tar.gz
Patch: talloc-alt-fix-python-ldflags.patch

BuildRequires: docbook-dtds docbook-style-xsl libacl-devel libcap-devel python-devel xsltproc

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel

%description
A library that implements a hierarchical allocator with destructors.

%package devel
Group: Development/C
Summary: Developer tools for the Talloc library
Requires: %name = %EVR

%description devel
Header files needed to develop programs that link against the Talloc library.

%package -n python3-module-talloc
Group: Development/Python3
Summary: Python3 bindings for the Talloc library
Requires: libtalloc = %EVR
Provides: libpytalloc = %EVR
Obsoletes: libpytalloc < %EVR

%description -n python3-module-talloc
Python 3 libraries for creating bindings using talloc

%package -n python3-module-talloc-devel
Group: Development/Python3
Summary: Development libraries for python3-module-talloc
Requires: python3-module-talloc = %EVR
Provides: libpytalloc-devel = %EVR
Obsoletes: libpytalloc-devel < %EVR

%description -n python3-module-talloc-devel
Development libraries for python3-module-talloc

%prep
%setup -n talloc-%version
%patch -p1

%build
%undefine _configure_gettext
%configure	--disable-rpath \
		--disable-rpath-install \
		--bundled-libraries=NONE \
		--builtin-libraries=replace \
		--disable-silent-rules
%make_build

%install
%makeinstall_std

rm -f %buildroot%_libdir/*.a
rm -f %buildroot%_datadir/swig/*/talloc.i

%check
make test

%files
%_libdir/libtalloc.so.*

%files devel
%_includedir/talloc.h
%_libdir/libtalloc.so
%_pkgconfigdir/talloc.pc
%_man3dir/talloc.3.*

%files -n python3-module-talloc
%_libdir/libpytalloc-util.cpython*.so.*
%python3_sitelibdir/talloc.cpython*.so

%files -n python3-module-talloc-devel
%_includedir/pytalloc.h
%_pkgconfigdir/pytalloc-util.cpython-*.pc
%_libdir/libpytalloc-util.cpython*.so

%changelog
