# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define api 1.0
%define major 1
%define libname libzeitgeist%{api}_%{major}
%define develname libzeitgeist-devel

Name: libzeitgeist
Version: 0.3.18
Release: alt2_7
Summary: Client library for applications that want to interact with the Zeitgeist daemon
Group: System/Libraries
License: LGPLv3 and GPLv3
URL: https://launchpad.net/libzeitgeist
Source0: http://launchpad.net/%{name}/0.3/%{version}/+download/%{name}-%{version}.tar.gz
BuildRequires: pkgconfig(gio-2.0) >= 2.26
BuildRequires: pkgconfig(gio-unix-2.0)
BuildRequires: pkgconfig(glib-2.0) >= 2.26
BuildRequires: pkgconfig(gobject-2.0) >= 2.26
BuildRequires: gtk-doc
# for tests:
BuildRequires: dbus-tools dbus-tools-gui
# zeitgeist is just a runtime and the reason to install libzeitgeist
Requires: python-module-zeitgeist2.0 zeitgeist
Source44: import.info

%description
This project provides a client library for applications that want to interact
with the Zeitgeist daemon. The library is written in C using glib and provides
an asynchronous GObject oriented API.

%package -n %libname
Summary: Shared library for %name
Group: System/Libraries

%description -n %libname
This project provides a client library for applications that want to interact
with the Zeitgeist daemon. The library is written in C using glib and provides
an asynchronous GObject oriented API.

%package -n %develname
Summary: Development files for %{name}
Group: Development/C
Requires: %{libname} = %{version}-%{release}

%description -n %develname
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%prep
%setup -q

%build
%configure --disable-static
%make

%install
%makeinstall_std

install -d -p -m 755 %{buildroot}%{_datadir}/vala/vapi
install -D -p -m 644 bindings/zeitgeist-1.0.{vapi,deps} %{buildroot}%{_datadir}/vala/vapi
find %{buildroot} -name '*.la' -exec rm -f {} ';'

# remove duplicate documentation
rm -fr %{buildroot}%{_defaultdocdir}/%{name}

%files -n %libname
%doc COPYING COPYING.GPL README
%{_libdir}/libzeitgeist-%{api}.so.%{major}
%{_libdir}/libzeitgeist-%{api}.so.%{major}.*

%files -n %develname
%doc AUTHORS ChangeLog COPYING COPYING.GPL MAINTAINERS NEWS 
%doc examples/*.vala examples/*.c
%{_datadir}/gtk-doc/html/zeitgeist-1.0/
%{_includedir}/zeitgeist-1.0/
%{_libdir}/pkgconfig/zeitgeist-1.0.pc
%{_libdir}/*.so
%{_datadir}/vala/vapi/


%changelog
