%add_python3_path /usr/share/lirc/python-pkg/
Name: lirc
Version: 0.10.1
Release: alt3

Summary: The Linux Infrared Remote Control package
License: GPL-2.0-or-later and MIT
Group: System/Base
Url: http://www.lirc.org

Source: %name-%version.tar
Source1: lircd
Source2: lircd.sysconfig
Source3: lircd.service
Source4: liblircclient0.pc
Source5: confs_by_driver.yaml

Patch1: lirc-0.10.1-disable-getconfig.patch
Patch2: lirc-0.10.1-alt-sysmacros.patch

Obsoletes: %name-remotes

BuildRequires: libX11-devel libalsa-devel python3-dev xsltproc gcc-c++
BuildRequires: python3-module-setuptools libsystemd-devel libportaudio2-devel
BuildRequires: python3-module-yaml
BuildRequires(pre): rpm-build-python3

Requires: liblirc = %version-%release

%description
LIRC is a package that allows you to decode and send infra-red signals
of many (but not all) commonly used remote controls.

%package -n liblirc
Summary: Client library for LIRC
Group: System/Libraries

%description -n liblirc
Libraries needed by programs, which uses LIRC

%package -n liblirc-devel
Summary: Development for LIRC
Group: Development/C
Requires: lib%name = %version-%release

%description -n liblirc-devel
Development library for LIRC

%package config
Summary: LIRC Configuration Tools and Data
Requires: lirc = %version-%release
Group: System/Base
Requires: python3-module-pygobject3-pygtkcompat
Requires: python3-module-yaml

%description config
The LIRC config package contains tools and data  to ease the
LIRC configuration process.

%prep
%setup
%patch1 -p1
%patch2 -p1

%build
%add_optflags -I%_includedir/libftdi
cp %SOURCE5 configs/
%autoreconf
%configure  --disable-static --localstatedir=%_var \
	    --with-x --with-syslog --with-driver=userspace \
	    --enable-uinput --enable-devinput \
	    --with-port=0x3f8 --with-irq=4
make

%install
%makeinstall_std varrundir=%buildroot/%_runtimedir docdir=%_defaultdocdir/%name-%version
install -pm755 -D %SOURCE1 %buildroot%_initdir/lircd
install -pm644 -D %SOURCE2 %buildroot%_sysconfdir/sysconfig/lircd
install -pm644 -D %SOURCE4 %buildroot%_datadir/pkgconfig/liblircclient0.pc
mkdir -p %buildroot/%_runtimedir/lirc %buildroot%_tmpfilesdir
echo 'd /run/lirc 0755 root root' > %buildroot%_tmpfilesdir/lirc.conf
# relocate to docdir to avoid python deps
rm -f %buildroot%_bindir/pronto2lirc
rm -rf %buildroot%_datadir/lirc/contrib
mv %buildroot/%_libdir/pkgconfig/* %buildroot%_datadir/pkgconfig/
sed -i -e '/^plugindir/s|%buildroot||' %buildroot%_sysconfdir/lirc/lirc_options.conf
ln -sf `readlink %buildroot%_bindir/lirc-setup|sed 's,3\..,3,'` %buildroot%_bindir/lirc-setup
mkdir -p %buildroot%python3_sitelibdir/lirc
cp %buildroot%_datadir/lirc/python-pkg/config.py %buildroot%python3_sitelibdir/lirc



%triggerun -- lirc < 0.9.2
if [ $2 -gt 0 ] && [ $1 -gt 0 ] && [ -f /etc/lircd.conf ]; then
# This is upgrade.
	echo "Warning: configuration files from /etc/lirc.conf moved to /etc/lirc/lircd.conf.d/lircd-saved.conf"
	mkdir -p %_sysconfdir/lirc/lirc.conf.d >dev/null 2>&1 ||:
	mv /etc/lircd.conf /etc/lirc/lircd.conf.d/lircd-saved.conf ||:
	%post_service lircd
fi


%pre
/usr/sbin/groupadd -r -f %name &> /dev/null ||:

%post
%post_service lircd

%preun
%preun_service lircd

%files
%doc NEWS doc/irxevent.keys doc/html configs contrib
%config(noreplace) %_sysconfdir/sysconfig/lircd
%config(noreplace) %_sysconfdir/lirc/*
%dir %_sysconfdir/lirc
%systemd_unitdir/*.service
%systemd_unitdir/*.socket
%_initdir/*
%_bindir/*
%exclude %_bindir/irdb-get
%exclude %_bindir/lirc-config-tool
%exclude %_bindir/lirc-setup
%attr(2711,root,%name) %_sbindir/lircd
%_sbindir/lircmd
%_sbindir/lircd-uinput
%_sbindir/lirc-lsplugins
%_man1dir/*.1*
%exclude %_mandir/man1/irdb-get*
%exclude %_mandir/man1/lirc-config-tool*
%exclude %_mandir/man1/lirc-setup*
%_man5dir/*.5*
%_man8dir/*.8*
%_tmpfilesdir/lirc.conf
%_runtimedir/lirc

%files -n liblirc
%_libdir/liblirc_client.so.*
%_libdir/liblirc.so.*
%_libdir/libirrecord.so.*
%_libdir/liblirc_driver.so.*
%_libdir/lirc

%files -n liblirc-devel
%_libdir/*.so
%_includedir/*
%_datadir/pkgconfig/*

%files config
%_bindir/irdb-get
%_bindir/lirc-config-tool
%_bindir/lirc-setup
%_sbindir/lircd-setup
%_mandir/man1/irdb-get*
%_mandir/man1/lirc-config-tool*
%_mandir/man1/lirc-setup*
%_datadir/lirc/configs
%_datadir/lirc/lirc.hwdb
%_datadir/lirc/python-pkg
%python3_sitelibdir/lirc
%python3_sitelibdir/lirc-setup

%changelog
