%global v_major 10.0
%global llvm_name llvm%v_major
%global clang_name clang%v_major
%global lld_name lld%v_major

# Decrease debuginfo verbosity to reduce memory consumption during final library linking
%ifarch %ix86 %arm
%define optflags_debug -g0
#define __nprocs 1
%else
%define optflags_debug -g1
%endif

%def_disable tests
%def_without clang

Name: %llvm_name
Version: 10.0.0
Release: alt0.2.p9
Summary: The Low Level Virtual Machine

Group: Development/C
License: NCSA
Url: http://llvm.org
Source0: https://github.com/llvm/llvm-project/releases/download/llvmorg-%version/llvm-%version.src.tar.xz
Source1: https://github.com/llvm/llvm-project/releases/download/llvmorg-%version/clang-%version.src.tar.xz
Source2: https://github.com/llvm/llvm-project/releases/download/llvmorg-%version/lld-%version.src.tar.xz
Source3: https://github.com/llvm/llvm-project/releases/download/llvmorg-%version/compiler-rt-%version.src.tar.xz
Patch:  clang-alt-i586-fallback.patch
Patch1: clang-9-alt-triple.patch
Patch2: llvm-alt-cmake-path.patch
Patch3: llvm-alt-fix-linking.patch
Patch4: llvm-alt-triple.patch
Patch5: compiler-rt-9-alt-i586-arch.patch
Patch6: RH-0001-CMake-Split-static-library-exports-into-their-own-ex.patch
Patch7: clang-alt-aarch64-dynamic-linker-path.patch
Patch8: 0001-Don-t-set-rpath-when-installing.patch
Patch9: lld-9-alt-mipsel-permit-textrels-by-default.patch
Patch10: llvm-10-alt-python3.patch
Patch11: 0001-PowerPC-PPCBoolRetToInt-Skip-translation-if-there-is.patch

# ThinLTO requires /proc/cpuinfo to exists so the same does llvm
BuildPreReq: /proc

BuildRequires(pre): cmake >= 3.4.3
BuildRequires: rpm-build >= 4.0.4-alt112 libncursesw-devel
BuildRequires: chrpath libstdc++-devel libffi-devel perl-Pod-Parser perl-devel
BuildRequires: python3-module-recommonmark zip zlib-devel binutils-devel ninja-build
%if_with clang
BuildRequires: %clang_name %llvm_name-devel %lld_name
%else
BuildRequires: gcc-c++
%endif

Provides: llvm = %EVR
Obsoletes: llvm < %version
Conflicts: llvm7.0

%description
LLVM is a compiler infrastructure designed for compile-time, link-time,
runtime, and idle-time optimization of programs from arbitrary
programming languages. The compiler infrastructure includes mirror sets
of programming tools as well as libraries with equivalent functionality.

%package devel
Group: Development/C
Summary: Libraries and header files for LLVM
Provides: llvm-devel = %EVR
Obsoletes: llvm-devel < %version
Conflicts: llvm7.0-devel
Requires: %name = %EVR

%description devel
This package contains library and header files needed to develop new
native programs that use the LLVM infrastructure.

%package devel-static
Summary: Static libraries for LLVM
Group: Development/C
Provides: llvm-devel-static = %EVR
Obsoletes: llvm-devel-static < %version
Conflicts: llvm7.0-devel-static
Requires: %name-devel = %EVR

%description devel-static
This package contains static libraries needed to develop new
native programs that use the LLVM infrastructure.

%package libs
Group: Development/C
Summary: LLVM shared libraries

%description libs
Shared libraries for the LLVM compiler infrastructure.

%package doc
Summary: Documentation for LLVM
Group: Documentation
BuildArch: noarch
Provides: llvm-doc = %EVR
Obsoletes: llvm-doc < %version
Conflicts: llvm7.0-doc

%description doc
Documentation for the LLVM compiler infrastructure.

%package -n %clang_name
Summary: A C language family frontend for LLVM
Group: Development/C
Requires: gcc
Provides: clang = %EVR
Obsoletes: clang < %version
Conflicts: clang7.0

%description -n %clang_name
clang: noun
    1. A loud, resonant, metallic sound.
    2. The strident call of a crane or goose.
    3. C-language family front-end toolkit.

The goal of the Clang project is to create a new C, C++, Objective C
and Objective C++ front-end for the LLVM compiler. Its tools are built
as libraries and designed to be loosely-coupled and extendable.

%package -n %clang_name-libs
Group: Development/C
Summary: clang shared libraries

%description -n %clang_name-libs
Shared libraries for the clang compiler.

%package -n %clang_name-devel
Summary: Header files for clang
Group: Development/C
Provides: clang-devel = %EVR
Obsoletes: clang-devel < %version
Conflicts: clang7.0-devel
Requires: %clang_name = %EVR

%description -n %clang_name-devel
This package contains header files for the Clang compiler.

%package -n %clang_name-devel-static
Summary: Static libraries for clang
Group: Development/C
Provides: clang-devel-static = %EVR
Obsoletes: clang-devel-static < %version
Conflicts: clang7.0-devel-static
Requires: %clang_name-devel = %EVR

%description -n %clang_name-devel-static
This package contains static libraries for the Clang compiler.

%package -n %clang_name-analyzer
Summary: A source code analysis framework
Group: Development/C
BuildArch: noarch
Provides: clang-analyzer = %EVR
Obsoletes: clang-analyzer < %version
Conflicts: clang7.0-analyzer
Requires: %clang_name = %EVR

%description -n %clang_name-analyzer
The Clang Static Analyzer consists of both a source code analysis
framework and a standalone tool that finds bugs in C and Objective-C
programs. The standalone tool is invoked from the command-line, and is
intended to run in tandem with a build of a project or code base.

%package -n %clang_name-doc
Summary: Documentation for Clang
Group: Documentation
BuildArch: noarch
Provides: clang-doc = %EVR
Obsoletes: clang-doc < %version
Conflicts: clang7.0-doc

%description -n %clang_name-doc
Documentation for the Clang compiler front-end.

%package -n %lld_name
Summary: LLD - The LLVM Linker
Group: Development/C
Provides: lld = %EVR
Obsoletes: lld < %version

%description -n %lld_name
LLD is a linker from the LLVM project. That is a drop-in replacement for system
linkers and runs much faster than them. It also provides features that are
useful for toolchain developers.

%package -n %lld_name-devel
Summary: Header files for LLD
Group: Development/C
Provides: lld-devel = %EVR
Obsoletes: lld-devel < %version
Requires: %lld_name = %EVR

%description -n %lld_name-devel
This package contains header files for the LLD linker.

%package -n %lld_name-doc
Summary: Documentation for LLD
Group: Documentation
BuildArch: noarch
Provides: lld-doc = %EVR
Obsoletes: lld-doc < %version

%description -n %lld_name-doc
Documentation for the LLD linker.

%prep
%setup -n llvm-%version.src -a1 -a2 -a3
for pkg in clang lld; do
   mv $pkg-%version.src tools/$pkg
done
mv compiler-rt-%version.src projects/compiler-rt
%patch -p1 -b .alt-i586-fallback
%patch1 -p1 -b .alt-triple
%patch2 -p1 -b .alt-cmake-path
%patch3 -p1 -b .alt-fix-linking
%patch4 -p1 -b .alt-triple
%patch5 -p1 -b .alt-i586-arch
%patch6 -p1
%patch7 -p1 -b .alt-aarch64-dynamic-linker
%patch8 -p1
%patch9 -p1 -b .alt-mipsel-permit-textrels-by-default
%patch10 -p1
%patch11 -p2

%build
%cmake -G Ninja \
	-DLLVM_PARALLEL_LINK_JOBS=1 \
	-DCMAKE_BUILD_TYPE=Release \
	-DBUILD_SHARED_LIBS:BOOL=OFF \
	-DLLVM_TARGETS_TO_BUILD="host;AMDGPU;BPF;NVPTX;" \
	-DLLVM_EXPERIMENTAL_TARGETS_TO_BUILD='AVR' \
	-DLLVM_ENABLE_LIBCXX:BOOL=OFF \
	-DLLVM_ENABLE_ZLIB:BOOL=ON \
	-DLLVM_ENABLE_FFI:BOOL=ON \
	-DLLVM_ENABLE_RTTI:BOOL=ON \
	-DLLVM_OPTIMIZED_TABLEGEN:BOOL=ON \
	-DLLVM_BINUTILS_INCDIR="%_includedir/bfd" \
	\
	-DCLANG_PLUGIN_SUPPORT:BOOL=ON \
	-DCLANG_LINK_CLANG_DYLIB=ON \
	\
	%if_with clang
	-DLLVM_ENABLE_LTO=Thin \
	-DCMAKE_C_COMPILER=clang \
	-DCMAKE_CXX_COMPILER=clang++ \
	-DCMAKE_RANLIB:PATH=%_bindir/llvm-ranlib \
	-DCMAKE_AR:PATH=%_bindir/llvm-ar \
	-DCMAKE_NM:PATH=%_bindir/llvm-nm \
	-DLLVM_ENABLE_LLD:BOOL=ON \
	%else
	-DLLVM_ENABLE_LTO=On \
	-DLLVM_USE_LINKER=gold \
	-DCMAKE_AR:PATH=%_bindir/gcc-ar \
	-DCMAKE_NM:PATH=%_bindir/gcc-nm \
	-DCMAKE_RANLIB:PATH=%_bindir/gcc-ranlib \
	-DCMAKE_SHARED_LINKER_FLAGS="-Wl,-Bsymbolic" \
	%endif
	\
	-DLLVM_LIBDIR_SUFFIX="%_libsuff" \
	-DLLVM_BUILD_RUNTIME:BOOL=ON \
	\
	-DLLVM_INCLUDE_TOOLS:BOOL=ON \
	-DLLVM_BUILD_TOOLS:BOOL=ON \
	\
	%if_enabled tests
	-DLLVM_INCLUDE_TESTS:BOOL=ON \
	-DLLVM_BUILD_TESTS:BOOL=ON \
	%endif
	\
	-DLLVM_INCLUDE_EXAMPLES:BOOL=ON \
	-DLLVM_BUILD_EXAMPLES:BOOL=OFF \
	\
	-DLLVM_INCLUDE_UTILS:BOOL=ON \
	-DLLVM_INSTALL_UTILS:BOOL=OFF \
	\
	-DLLVM_INCLUDE_DOCS:BOOL=ON \
	-DLLVM_BUILD_DOCS:BOOL=ON \
	-DLLVM_ENABLE_SPHINX:BOOL=ON \
	-DSPHINX_WARNINGS_AS_ERRORS:BOOL=OFF \
	-DSPHINX_EXECUTABLE=%_bindir/sphinx-build-3 \
	-DLLVM_ENABLE_DOXYGEN:BOOL=OFF \
	-DLLVM_BUILD_LLVM_DYLIB:BOOL=ON \
	-DLLVM_LINK_LLVM_DYLIB:BOOL=ON \
	-DLLVM_INSTALL_TOOLCHAIN_ONLY:BOOL=OFF \
	-DPYTHON_EXECUTABLE=%_bindir/python3

sed -i 's|man\ tools/lld/docs/docs-lld-html|man|' BUILD/build.ninja
ninja -vvv -j %__nprocs -C BUILD

%install
pushd BUILD
cmake -DCMAKE_INSTALL_PREFIX=%buildroot%prefix ../
sed -i 's|man\ tools/lld/docs/docs-lld-html|man|' build.ninja
sed -i '/^[[:space:]]*include.*tools\/lld\/docs\/cmake_install.cmake.*/d' tools/lld/cmake_install.cmake
popd
ninja -C BUILD install

# And prepare Clang documentation
rm -rf BUILD/clang-docs
mkdir -p BUILD/clang-docs
for f in LICENSE.TXT NOTES.txt README.txt; do
  ln tools/clang/$f BUILD/clang-docs/
done
rm -rf tools/clang/docs/{doxygen*,Makefile*,*.graffle,tools}

install -m 0755 BUILD/%_lib/LLVMHello.so %buildroot%_libdir/
install -m 0755 BUILD/%_lib/BugpointPasses.so %buildroot%_libdir/
mkdir -p %buildroot%_docdir/lld

file %buildroot%_bindir/* | awk -F: '$2~/ELF/{print $1}' | xargs -r chrpath -d
file %buildroot%_libdir/*.so | awk -F: '$2~/ELF/{print $1}' | xargs -r chrpath -d

%ifarch %ix86
cd %buildroot%_libdir/clang/%version/lib/linux
ls *-i[3-9]86* | while read f; do ln -s $f $(echo $f | sed 's|i[3-9]86|i386|') ; done
%endif

%check
%if_enabled tests
LD_LIBRARY_PATH=%buildroot%_libdir:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH
ninja -C BUILD check-all || :
%endif

%files
%doc CREDITS.TXT LICENSE.TXT README.txt
%_bindir/*
%_man1dir/*
%exclude %_bindir/llvm-config*
%exclude %_bindir/*clang*
%exclude %_bindir/c-index-test
%exclude %_bindir/scan-*
%exclude %_man1dir/llvm-config.1.*
%exclude %_man1dir/clang.1*
%exclude %_man1dir/scan-build.1*
%exclude %_bindir/lld*
%exclude %_bindir/ld*.lld
%exclude %_bindir/wasm-ld

%files libs
%_libdir/libLLVM-*.so
%_libdir/libLTO.so.*
%_libdir/libRemarks.so.*

%files devel
%_bindir/llvm-config
%_man1dir/llvm-config.1.*
%_includedir/llvm
%_includedir/llvm-c
%_libdir/libLLVM.so
%_libdir/libLTO.so
%_libdir/LLVMgold.so
%_libdir/libRemarks.so
%_libdir/LLVMHello.so
%_libdir/BugpointPasses.so
%_datadir/cmake/Modules/llvm
%exclude %_datadir/cmake/Modules/llvm/LLVMStaticExports.cmake

%files devel-static
%_libdir/*.a
%exclude %_libdir/libclang*.a
%_datadir/cmake/Modules/llvm/LLVMStaticExports.cmake

%files -n %clang_name
%doc BUILD/clang-docs/*
%_bindir/*clang*
%_bindir/c-index-test
%_man1dir/clang.1*

%files -n %clang_name-libs
%_libdir/clang
%_libdir/libclang*.so.*

%files -n %clang_name-devel
%_includedir/clang
%_includedir/clang-c
%_libdir/libclang*.so
%_datadir/cmake/Modules/clang

%files -n %clang_name-devel-static
%_libdir/libclang*.a

%files -n %clang_name-analyzer
%_prefix/libexec/*-analyzer
%_bindir/scan-build
%_bindir/scan-view
%_datadir/scan-build
%_datadir/scan-view
%_man1dir/scan-build.1*

%files -n %lld_name
%_bindir/lld*
%_bindir/ld*.lld
%_bindir/wasm-ld

%files -n %lld_name-devel
%dir %_includedir/lld
%_includedir/lld/*

%files doc
%doc %_docdir/llvm

%files -n %clang_name-doc
%doc %_docdir/clang

%files -n %lld_name-doc
%doc %_docdir/lld

%changelog
