%define _unpackaged_files_terminate_build 1

Name: merkaartor
Version: 0.18.4
Release: alt3

Summary: an OpenStreetMap editor
License: GPLv2
Group: Sciences/Geosciences
Url: https://github.com/openstreetmap/merkaartor

# https://github.com/openstreetmap/merkaartor.git
Source: %name-%version.tar
Patch1: %name-0.18.3-fedora-no-git-version.patch
Patch2: %name-%version-upstream-qt5-compat.patch

BuildRequires: boost-devel gcc-c++ glibc-devel-static
BuildRequires: libgdal-devel libproj-devel libexiv2-devel zlib-devel libsqlite3-devel
BuildRequires: qt5-base-devel qt5-svg-devel qt5-tools-devel
BuildRequires: qt5-webengine-devel
BuildRequires: libqtsingleapplication-qt5-devel

%description
Merkaartor is an openstreetmap mapping program.
Merkaartor focuses on providing a visually pleasing but performant
editing environment for free geographical data.

%prep
%setup
%patch1 -p1
%patch2 -p1

# remove bundled libraries
rm -rf 3rdparty

%build
%add_optflags -DACCEPT_USE_OF_DEPRECATED_PROJ_API_H=1
%add_optflags -I%_includedir/qt5/QtSolutions

lrelease-qt5 Merkaartor.pro
qmake-qt5 \
	CONFIG+=release CONFIG+=force_debug_info \
	PREFIX=%_prefix \
	USEWEBENGINE=1 \
	SYSTEM_QTSA=1 \
	TRANSDIR_MERKAARTOR=%_datadir/%name/translations/ \
	-after QMAKE_CFLAGS+='%optflags' \
	-after QMAKE_CXXFLAGS+='%optflags' \
	Merkaartor.pro

%make_build

%install
%make_install INSTALL_ROOT=%buildroot LIB_SUFFIX=%_libsuff install

%files
%_bindir/merkaartor
%_datadir/%name/
%_libdir/%name/
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/*.png

%changelog
