Name: mongo
Version: 4.0.28
Release: alt1
Summary: mongo client shell and tools
License: SSPL 1.0
Url: http://www.mongodb.org
Group: Development/Databases
# From https://docs.mongodb.com/manual/installation
# Changed in version 3.4: MongoDB no longer supports 32-bit x86 platforms.
ExclusiveArch: x86_64 aarch64 ppc64le

Source: %name-%version.tar
Patch1:         mongodb-2.4.5-no-term.patch

BuildRequires: /proc gcc-c++ python-devel python-module-pymongo scons
BuildRequires: boost-devel boost-filesystem-devel boost-program_options-devel
BuildRequires: libssl-devel libpcre-devel libpcrecpp-devel libreadline-devel
BuildRequires: libpcap-devel libsnappy-devel
BuildRequires: systemd-devel libgperftools-devel libsasl2-devel libstemmer-devel
BuildRequires: libyaml-cpp-devel valgrind-devel zlib-devel python-modules-json
BuildRequires: python-module-Cheetah python-module-typing python-module-yaml
BuildRequires: libcurl-devel

%description
Mongo (from "huMONGOus") is a schema-free document-oriented database.
It features dynamic profileable queries, full indexing, replication
and fail-over support, efficient storage of large binary data objects,
and auto-sharding.

This package provides the mongo shell.

%package server-mongod
Summary: mongo server, sharding server,  and support scripts
Group: Development/Databases
Provides: %name-server
Obsoletes: %name-server

%description server-mongod
Mongo (from "huMONGOus") is a schema-free document-oriented database.

mongod is the primary daemon process for the MongoDB system.
It handles data requests, manages data format,
and performs background management operations.

%package server-mongos
Summary: mongo routing service, and support scripts
Group: Development/Databases

%description server-mongos
Mongo (from "huMONGOus") is a schema-free document-oriented database.

mongos for "MongoDB Shard," is a routing service for MongoDB shard
configurations that processes queries from the application layer,
and determines the location of this data in the sharded cluster,
in order to complete these operations. From the perspective of the
application, a mongos instance behaves identically to any other
MongoDB instance.


%prep
%setup
%patch1 -p1

# CRLF -> LF
sed -i 's/\r//' README

# Disable optimization for s2 library
# https://jira.mongodb.org/browse/SERVER-17511
sed -i -r "s|(env.Append\(CCFLAGS=\['-DDEBUG_MODE=false')(\]\))|\1,'-O0'\2|"  src/third_party/s2/SConscript

%build
# NOTE: Build flags must be EXACTLY the same in the install step!
# If you fail to do this, mongodb will be built twice...
%ifarch aarch64
%define ccflags_arch_opts "-march=armv8-a+crc"
%endif
%define common_opts \\\
       -j %__nprocs \\\
       --use-system-tcmalloc \\\
       --use-system-pcre \\\
       --use-system-snappy \\\
       --use-system-valgrind \\\
       --use-system-zlib \\\
       --use-system-stemmer \\\
       --use-system-yaml \\\
       --prefix=%buildroot%_prefix \\\
       --nostrip \\\
       --use-sasl-client \\\
       --wiredtiger=on \\\
       --ssl \\\
       --disable-warnings-as-errors \\\
       MONGO_VERSION="%{version}-%{release}" \\\
       CCFLAGS="%{?optflags} %{?ccflags_arch_opts} `pkg-config --cflags libpcrecpp`"

scons core tools %common_opts

%install
scons install %common_opts

mkdir -p %buildroot%_logdir/%name
mkdir -p %buildroot%_runtimedir/%name
mkdir -p %buildroot%_localstatedir/%name
mkdir -p %buildroot%_man1dir
cp debian/*.1 %buildroot%_man1dir/

#mongod
install -p -D -m 644 mongod.logrotate %buildroot%_logrotatedir/mongod
install -p -D -m 755 mongod.init.alt %buildroot%_initddir/mongod
install -p -D -m 644 mongod.conf %buildroot%_sysconfdir/%name/mongod.conf
install -p -D -m 644 mongod.sysconf %buildroot%_sysconfdir/sysconfig/mongod
install -p -D -m 644 mongod.service %buildroot%_unitdir/mongod.service
install -p -D -m 644 mongod.tmpfile %buildroot%_tmpfilesdir/mongod.conf

#mongos
install -p -D -m 644 mongos.logrotate %buildroot%_logrotatedir/mongos
install -p -D -m 755 mongos.init.alt %buildroot%_initddir/mongos
install -p -D -m 644 mongos.conf %buildroot%_sysconfdir/%name/mongos.conf
install -p -D -m 644 mongod.sysconf %buildroot%_sysconfdir/sysconfig/mongos
install -p -D -m 644 mongos.service %buildroot%_unitdir/mongos.service
install -p -D -m 644 mongod.tmpfile %buildroot%_tmpfilesdir/mongos.conf

%pre server-mongod
%_sbindir/groupadd -r -f mongod ||:
%_sbindir/useradd -r -n -g mongod -d /var/lib/mongo -s /bin/false -c "Mongod pseudo user" mongod >/dev/null 2>&1 ||:

%post server-mongod
%post_service mongod

%preun server-mongod
%preun_service mongod

%pre server-mongos
%_sbindir/groupadd -r -f mongod ||:
%_sbindir/useradd -r -n -g mongod -d /var/lib/mongo -s /bin/false -c "Mongod pseudo user" mongod >/dev/null 2>&1 ||:

%post server-mongos
%post_service mongos

%preun server-mongos
%preun_service mongos


%files
%doc README LICENSE-Community.txt

%_bindir/mongo
%exclude %_bindir/install_compass

%_man1dir/mongo.1*

# man pages for mongo-tools
%exclude %_man1dir/bsondump.1*
%exclude %_man1dir/mongodump.1*
%exclude %_man1dir/mongoexport.1*
%exclude %_man1dir/mongofiles.1*
%exclude %_man1dir/mongoimport.1*
%exclude %_man1dir/mongorestore.1*
%exclude %_man1dir/mongostat.1*
%exclude %_man1dir/mongotop.1*

%files server-mongod
%doc README LICENSE-Community.txt
%config(noreplace) %_sysconfdir/%name/mongod.conf
%config(noreplace) %_sysconfdir/sysconfig/mongod
%config(noreplace) %_logrotatedir/mongod
%_bindir/mongod
%_man1dir/mongod.1*
%_initdir/mongod
%systemd_unitdir/mongod.service
%_tmpfilesdir/mongod.conf
%attr(0750,mongod,mongod) %dir %_localstatedir/%name
%attr(1770,root,mongod) %dir %_logdir/%name
%attr(0750,mongod,mongod) %dir %_runtimedir/%name

%files server-mongos
%doc README LICENSE-Community.txt
%config(noreplace) %_sysconfdir/%name/mongos.conf
%config(noreplace) %_sysconfdir/sysconfig/mongos
%config(noreplace) %_logrotatedir/mongos
%_bindir/mongos
%_man1dir/mongos.1*
%_initdir/mongos
%systemd_unitdir/mongos.service
%_tmpfilesdir/mongos.conf
%attr(1770,root,mongod) %dir %_logdir/%name
%attr(0750,mongod,mongod) %dir %_runtimedir/%name

%changelog
