Name: nasm
Version: 2.14.02
Release: alt1

Summary: The Netwide Assembler, a portable x86 assembler with Intel-like syntax
License: BSD 2-clause
Group: Development/Other
Url: http://www.nasm.us/

#VCS: https://repo.or.cz/nasm.git
Source: http://www.nasm.us/pub/nasm/releasebuilds/%version/nasm-%version.tar.bz2

BuildRequires: ghostscript-utils groff-base xmlto asciidoc-a2x
BuildRequires: texinfo
BuildRequires: perl-Font-TTF perl-Sort-Versions
# some fonts required, see doc/psfonts.ph
BuildRequires: fonts-otf-adobe-source-code-pro fonts-otf-adobe-source-sans-pro fonts-ttf-liberation

%package doc
Summary: Extensive documentation for NASM
Group: Development/Other
BuildArch: noarch

%package rdoff
Summary: Tools for the RDOFF binary format, sometimes used with NASM
Group: Development/Other

%description
NASM is the Netwide Assembler, a free portable assembler for the Intel
80x86 microprocessor series, using primarily the traditional Intel
instruction mnemonics and syntax.

%description doc
Extensive documentation for the Netwide Assembler, NASM, in HTML,
PostScript and text formats.

%description rdoff
Tools for the operating-system independent RDOFF binary format, which
is sometimes used with the Netwide Assembler (NASM). These tools
include linker, library manager, loader, and information dump.

%prep
%setup

%build
%configure
%make_build everything

%install
%makeinstall_std install_rdf

cd doc
gzip -9f *.txt *.ps || true
cd html
ln -sf nasmdoc0.html index.html

%files
%doc CHANGES TODO AUTHORS README doc/internal.doc
%_bindir/nasm
%_bindir/ndisasm
%_man1dir/nasm.1*
%_man1dir/ndisasm.1*

%files doc
%doc doc/nasmdoc.pdf doc/nasmdoc.txt.gz doc/html

%files rdoff
%doc rdoff/README
%_bindir/ldrdf
%_bindir/rdf2bin
%_bindir/rdf2com
%_bindir/rdfdump
%_bindir/rdf2ihx
%_bindir/rdf2ith
%_bindir/rdflib
%_bindir/rdf2srec
%_bindir/rdx
%_man1dir/*rdf*
%_man1dir/rdx*

%changelog
