%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define ver_major 3.32
%define api_ver 3.0
%define xdg_name org.gnome.Nautilus

%def_enable packagekit
%def_enable tracker
%def_enable introspection
%def_enable selinux
%def_enable docs
%def_disable check

Name: nautilus
Version: %ver_major.3
Release: alt1

Summary: Nautilus is a network user environment
License: GPLv2+
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Nautilus

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define icon_theme_ver 2.10.0
%define desktop_file_utils_ver 0.8

%define glib_ver 2.55.1
%define desktop_ver 3.3.3
%define pango_ver 1.28.3
%define gtk_ver 3.22.27
%define libxml2_ver 2.4.7
%define gexiv2_ver 0.10
%define gir_ver 0.10.2
%define tracker_ver 2.0
%define autoar_ver 0.2.1

Requires(post): libcap-utils
Requires: lib%name = %version-%release
Requires: gnome-icon-theme >= %icon_theme_ver
Requires: shared-mime-info
Requires: common-licenses
Requires: gvfs >= 1.34
Requires: %_bindir/bwrap
Requires: totem-video-thumbnailer
%{?_enable_tracker:Requires: tracker}

BuildRequires(pre): meson rpm-build-gnome rpm-build-licenses
BuildRequires: desktop-file-utils >= %desktop_file_utils_ver
BuildRequires: libappstream-glib-devel
# for %%check
BuildRequires: xvfb-run dbus-tools-gui /proc

BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgnome-desktop3-devel >= %desktop_ver
BuildRequires: libpango-devel >= %pango_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: gsettings-desktop-schemas-devel
BuildRequires: libxml2-devel >= %libxml2_ver
BuildRequires: libgexiv2-devel >= %gexiv2_ver
BuildRequires: libgnome-autoar-devel >= %autoar_ver
BuildRequires: libX11-devel
BuildRequires: libseccomp-devel
BuildRequires: pkgconfig(gstreamer-tag-1.0)
%{?_enable_docs:BuildRequires: docbook-utils gtk-doc}
%{?_enable_tracker:BuildRequires: pkgconfig(tracker-sparql-2.0)}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gir_ver libgtk+3-gir-devel}
%{?_enable_selinux:BuildRequires: libselinux-devel}

%description
Nautilus integrates access to files, applications, media, Internet-based
resources and the Web.  Nautilus delivers a dynamic and rich user
experience.  Nautilus is an free software project developed under the
GNU General Public License and is a core component of the GNOME desktop
project.

%package -n lib%name
Summary: Shared libraries needed to run Nautilus
Group: System/Libraries

%description -n lib%name
This package contains shared libraries needed to run Nautilus and its
components.

%package -n lib%name-devel
Summary: Libraries and include files for developing Nautilus components
Group: Development/GNOME and GTK+
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides the necessary development libraries and include
files to allow you to develop Nautilus components.

%package -n lib%name-devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
Conflicts: lib%name-devel < %version-%release
BuildArch: noarch

%description -n lib%name-devel-doc
This package contains development documentation for the %name.

%package -n lib%name-gir
Summary: GObject introspection data for the nautilus-extension library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the nautilus-extension library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the nautilus-extension library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the nautilus-extension library

%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup

%build
%meson \
    %{?_enable_docs:-Ddocs=true} \
    %{?_disable_packagekit:-Dpackagekit=false} \
    -Dextensions=true \
    %{?_enable_selinux:-Dselinux=true}
%meson_build

%install
%meson_install
bzip2 -9fk NEWS
# The license
ln -sf %_licensedir/LGPL-2 COPYING
%find_lang %name

%check
%meson_test

%post
# for mount secure NFS shares
setcap 'cap_net_bind_service=+ep' %_bindir/%name 2>/dev/null ||:

%files -f %name.lang
%_bindir/*
%dir %_libdir/%name
%_desktopdir/*.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/dbus-1/services/org.freedesktop.FileManager1.service
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%_iconsdir/hicolor/scalable/apps/%xdg_name.svg
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%config %_datadir/glib-2.0/schemas/org.gnome.nautilus.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml
# docs
%doc --no-dereference COPYING
%doc NEWS.bz2 README*
%_man1dir/*

%files -n lib%name
%_libdir/libnautilus-extension.so.*
%dir %_libdir/%name/extensions-%api_ver
%_libdir/%name/extensions-%api_ver/libnautilus-sendto.so
%_libdir/%name/extensions-%api_ver/libnautilus-image-properties.so
%_libdir/%name/extensions-%api_ver/libtotem-properties-page.so

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%files -n lib%name-devel-doc
%_gtk_docdir/*

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*

%files -n lib%name-gir-devel
%_girdir/*
%endif


%changelog
