%def_enable snapshot
%define ver_major 1.2

%def_enable gtk_doc

Name: nautilus-python
Version: %ver_major.2
Release: alt2

Summary: Python bindings for Nautilus
Group: Development/Python3
License: GPLv2+
Url: http://www.gnome.org/

Provides: python-module-nautilus = %version-%release
Obsoletes: python-module-nautilus

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%add_python3_path %nautilus_extdir

%define nautilus_ver 3.0.0
%define pygobject_ver 3.0

BuildRequires(pre): rpm-build-gnome rpm-build-python3
BuildRequires: libnautilus-devel >= %nautilus_ver libnautilus-gir-devel
BuildRequires: python3-devel python3-module-pygobject3-devel >= %pygobject_ver
%{?_enable_gtk_doc:BuildRequires: gtk-doc}

%description
This package provides Python bindings for the Nautilus extension library.

%package devel
Summary: Development files for %name
Group: Development/Python
Requires: %name = %version-%release
Provides: python-module-nautilus-devel = %version-%release
Obsoletes: python-module-nautilus-devel

%description devel
Development files for %name.

%package devel-doc
Summary: Development documentation for %name
Group: Development/Python
BuildArch: noarch
Conflicts: %name-devel < %version
Provides: python-module-nautilus-devel-doc = %version-%release
Obsoletes: python-module-nautilus-devel-doc

%description devel-doc
Development documentation for %name.

%prep
%setup

%build
%autoreconf
export PYTHON=%__python3
%configure \
	--disable-static \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	LIBS="$(python3-config --libs)"
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_datadir/nautilus-python/extensions
rm -f examples/{Makefile*,README.in}

%files
%nautilus_extdir/*.so
%dir %_datadir/nautilus-python/extensions

%files devel
%_pkgconfigdir/*
%doc README AUTHORS NEWS examples

%files devel-doc
%_datadir/gtk-doc/html/*

%exclude %nautilus_extdir/*.la
%exclude %_docdir/%name

%changelog
