Name: nickle
Version: 2.68
Release: alt2.1.qa1
Summary: A programming language-based prototyping environment

Group: Development/Other
License: MIT
Url: http://nickle.org
Packager: Ilya Mashkin <oddity@altlinux.ru>
Source0: http://nickle.org/release/nickle-%version.tar.gz

BuildRequires: libncurses-devel, libreadline-devel

%description
Nickle is a programming language based prototyping environment with
powerful programming and scripting capabilities. Nickle supports a
variety of datatypes, especially arbitrary precision numbers. The
programming language vaguely resembles C. Some things in C which do
not translate easily are different, some design choices have been made
differently, and a very few features are simply missing.

Nickle provides the functionality of UNIX bc, dc and expr in
much-improved form. It is also an ideal environment for prototyping
complex algorithms. Nickle's scripting capabilities make it a nice
replacement for spreadsheets in some applications, and its numeric
features nicely complement the limited numeric functionality of
text-oriented languages such as AWK and PERL.

%package devel
Summary: Include files for Nickle
Group: Development/Other
Requires: %name = %version-%release

%description devel
Include files for Nickle, used for bulding external FFI (foreign
function interface) libraries (e.g. the Cairo interface for Nickle).

%prep
%setup

%build
%configure
make %{?_smp_flags}

#check
#cd test
#make check

%install
make install DESTDIR=$RPM_BUILD_ROOT
rm `find examples -name 'Makefile*'`
rm examples/COPYING

# Fix permissions on example files
chmod a-x examples/menace2.5c
chmod a-x examples/turtle/snowflake.5c

%files
%doc README README.name COPYING AUTHORS NEWS TODO examples
%_bindir/nickle
%_datadir/nickle/
%exclude %_datadir/nickle/COPYING
%exclude %_datadir/nickle/examples
%_man1dir/nickle.1*

%files devel
%_includedir/nickle

%changelog
