# Disable tests because we can not increase build limits
%def_without tests

Name:           ninja-build
Version:        1.10.0
Release:        alt4

Summary:        A small build system with a focus on speed
Group:          Development/Tools
License:        Apache-2.0
URL:            https://ninja-build.org/

#VCS:           git://github.com/ninja-build/ninja.git
Source0:        %name-%version.tar
Source1:        ninja.vim
Source2:        ninja.1
Source3:        ninja.macros

BuildRequires: gcc-c++
BuildRequires: re2c
BuildRequires: asciidoc
BuildRequires: xsltproc
BuildRequires: docbook-style-xsl
BuildRequires: libgtest-devel

%description
Ninja is a small build system with a focus on speed. It differs from
other build systems in two major respects: it is designed to have its
input files generated by a higher-level build system, and it is designed
to run builds as fast as possible.

%package -n rpm-macros-%name
Summary:   Helper macros for building RPM packages with %name
Group:     System/Configuration/Packaging
BuildArch: noarch

%description -n rpm-macros-%name
A set of RPM macros for packaging applications that use %name.

%package -n rpm-build-ninja
Summary:   Helper macros for building RPM packages using %name
Group:     System/Configuration/Packaging
Requires:  rpm-macros-%name = %EVR
Requires:  %name = %EVR
BuildArch: noarch

%description -n rpm-build-ninja
A set of RPM macros for packaging applications using %name.

%prep
%setup

%build
#CFLAGS="%optflags"
#export CFLAGS
./configure.py --bootstrap --verbose --debug
./ninja -v manual
./ninja -v ninja_test

%check
%if_with tests
# workaround possible too low default limits
ulimit -n 2048
ulimit -u 2048
./ninja_test
%endif

%install
# TODO: Install ninja_syntax.py?
install -Dpm 755 ninja %buildroot%_bindir/ninja
# Compat symlink
ln -s ninja %buildroot%_bindir/ninja-build
install -Dpm 644 misc/bash-completion %buildroot%_sysconfdir/bash_completion.d/ninja-bash-completion
install -Dpm 644 misc/zsh-completion %buildroot%_datadir/zsh/site-functions/_ninja
install -Dpm 644 misc/ninja-mode.el %buildroot%_datadir/emacs/site-lisp/ninja-mode.el
install -Dpm 644 misc/ninja.vim %buildroot%_datadir/vim/vimfiles/syntax/ninja.vim
install -Dpm 644 %SOURCE1 %buildroot%_datadir/vim/vimfiles/ftdetect/ninja.vim
install -Dpm 644 %SOURCE2 %buildroot%_man1dir/ninja.1
install -Dpm 644 %SOURCE3 %buildroot%_rpmmacrosdir/ninja-build

%files
%doc COPYING README.md doc/manual.html
%_bindir/ninja-build
%_bindir/ninja
%_man1dir/*.1*
# bash-completion does not own this
%_sysconfdir/bash_completion.d/
# zsh does not have a -filesystem package
%_datadir/zsh/site-functions/_ninja
%_datadir/emacs/site-lisp/ninja-mode.el
%_datadir/vim/vimfiles/syntax/ninja.vim
%_datadir/vim/vimfiles/ftdetect/ninja.vim

%files -n rpm-macros-%name
%_rpmmacrosdir/%name

%files -n rpm-build-ninja

%changelog
