Name: nmap
Version: 7.80
Release: alt1
Epoch: 20020501

Summary: Network exploration tool and security scanner
License: GPLv2
Group: Monitoring
Url: http://nmap.org/

%define srcname nmap-%version-%release
# http://git.altlinux.org/gears/n/nmap.git
Source: %srcname.tar
Source1: zenmap.pamd
Source2: zenmap.security

%def_with liblua
%def_with ncat
%def_with ndiff
%def_with nping
%def_with zenmap

Requires: chrooted-resolv
BuildRequires: gcc-c++, libcap-devel
BuildRequires: libpcap-devel >= 2:0.8, libpcre-devel, libssl-devel, libssh2-devel, zlib-devel
%{?_with_liblua:BuildRequires: liblua5.3-devel}
%{?_with_ndiff:BuildRequires: python-devel}
%{?_with_zenmap:BuildRequires: libpam-devel python-devel}

%description
Nmap is an utility for network exploration or security auditing.
It supports ping scanning (determine which hosts are up), many port
scanning techniques, version detection (determine service protocols and
application versions listening behind ports), and TCP/IP fingerprinting
(remote host OS or device identification).  Nmap also offers flexible
target and port specification, decoy/stealth scanning, Sun RPC scanning,
and more.

%package -n zenmap
Summary: The GTK+ frontend for Nmap
Group: Monitoring
BuildArch: noarch
%_python_set_noarch
Requires: %name = %EVR

%description -n zenmap
This package includes zenmap, a GTK+ frontend for Nmap.

%prep
%setup -n %srcname
rm -r liblua libpcap libpcre libssh2 libz
bzip2 -9 CHANGELOG

%build
for d in . nping; do
	pushd $d
	aclocal
	autoheader
	autoconf
	popd
done

export ac_cv_header_libiberty_h=no
export ac_cv_dnet_linux_procfs=yes
%configure \
	%{subst_with liblua} \
	%{subst_with ncat} \
	%{subst_with ndiff} \
	%{subst_with nping} \
	%{subst_with zenmap} \
	--with-user=nmapuser \
	--with-chroot-empty=/var/empty \
	--with-chroot-resolv=/var/resolv \
	#
%make_build

%install
%makeinstall_std STRIP=:

rm %buildroot%_bindir/uninstall_ndiff
rm %buildroot%_mandir/*/man1/nmap.*

%if_with zenmap
ln -s $(relative %_libexecdir/consolehelper/helper %_bindir/) \
	%buildroot%_bindir/zenmap-root
install -pD -m640 %_sourcedir/zenmap.pamd \
	%buildroot%_sysconfdir/pam.d/zenmap-root
install -pD -m640 %_sourcedir/zenmap.security \
	%buildroot%_sysconfdir/security/console.apps/zenmap-root
mkdir -p %buildroot%_liconsdir
ln -s ../../../../zenmap/pixmaps/zenmap.png %buildroot%_liconsdir/
%find_lang zenmap
rm %buildroot%_bindir/{nmapfe,uninstall_zenmap,xnmap}
rm %buildroot%_datadir/zenmap/su-to-zenmap.sh
%endif

%pre
/usr/sbin/groupadd -r -f nmapuser
/usr/sbin/useradd -r -g nmapuser -d /dev/null -s /dev/null -n nmapuser >/dev/null 2>&1 ||:

%files
%_bindir/nmap
%_datadir/nmap
%_man1dir/nmap.*
%if_with ncat
%_bindir/ncat
%_man1dir/ncat.*
%endif
%if_with ndiff
%_bindir/ndiff
%_man1dir/ndiff.*
%endif
%if_with nping
%_bindir/nping
%_man1dir/nping.*
%endif
%doc COPYING* CHANGELOG.bz2 docs/{README,nmap*.txt}

%if_with zenmap
%files -n zenmap -f zenmap.lang
%config(noreplace) %_sysconfdir/pam.d/zenmap-root
%config(noreplace) %_sysconfdir/security/console.apps/zenmap-root
%_bindir/zenmap*
%_datadir/zenmap
%_man1dir/zenmap.*
%_liconsdir/*
%_desktopdir/zenmap*.desktop
%python_sitelibdir/*
%endif

%changelog
