# check deps/npm/package.json for it
%define npmver 6.14.12
# separate build npm
%def_without npm
# in other case, note: we will npm-@npmver-@release package! fix release if npmver is unchanged

%define major 14.17

#we need ABI virtual provides where SONAMEs aren't enough/not present so deps
#break when binary compatibility is broken
%global nodejs_abi 14

# there are both 6 and 7 provided (https://github.com/nodejs/node/pull/35199), see napi using
%global napi 7

# TODO: really we have no configure option to build with shared libv8
# V8 presently breaks ABI at least every x.y release while never bumping SONAME,
# so we need to be more explicit until spot fixes that
%global v8_abi 7.9
%def_without systemv8


# https://bugzilla.altlinux.org/show_bug.cgi?id=39716
%define openssl_version 1.1.1k
%def_with systemssl

%global libuv_abi 1.41.0-alt3
%def_with systemuv

%global libicu_abi 6.7
# rpm-build-info gives _distro_version
%if %_vendor == "alt" && (%_distro_version == "Sisyphus")
%def_with systemicu
# TODO: node has to use icu:: for ICU names
#add_optflags -DU_USING_ICU_NAMESPACE=1
%endif

%global libnghttp2_abi 1.41.0
%def_with systemnghttp2

# to use internal llhttp
%def_without systemhttpparser

%def_disable check

# https://nodejs.org/api/n-api.html
# https://github.com/nodejs/abi-stable-node
%def_with nodejs_abi

%define oversion %version

Name: node
Version: %major.2
Release: alt1

Summary: Evented I/O for V8 Javascript

Group: Development/Tools
License: MIT License
Url: http://nodejs.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

##Source-git: https://github.com/nodejs/node.git
# Source-url: https://nodejs.org/dist/v%version/node-v%version.tar.gz
Source: %name-%version.tar
Source7: nodejs_native.req.files

BuildRequires(pre): rpm-macros-nodejs
BuildRequires(pre): rpm-build-intro >= 2.1.14

BuildRequires: python3-devel gcc-c++ zlib-devel

BuildRequires: gyp
BuildRequires: python3-module-simplejson

%if_with systemv8
%define libv8_package libv8-nodejs
BuildRequires: %libv8_package-devel >= %v8_abi-devel
%endif

%if_with systemssl
BuildRequires: openssl-devel >= %openssl_version openssl
# for require strict library version
Requires: openssl >= %openssl_version
%endif

%if_with systemuv
BuildRequires: libuv-devel >= %libuv_abi
%endif

%if_with systemicu
BuildRequires: libicu-devel >= %libicu_abi
%endif

%if_with systemnghttp2
BuildRequires: libnghttp2-devel >= %libnghttp2_abi
%endif

%if_with systemhttpparser
BuildRequires: libhttp-parser-devel >= 2.9.2-alt2
%endif

# c-ares, see https://bugzilla.altlinux.org/show_bug.cgi?id=39303
BuildRequires: libcares-devel >= 1.16.1-alt2

BuildRequires: curl

%if_without npm
Requires: npm >= %npmver
%endif

Provides: nodejs(engine) = %version
Provides: nodejs = %version-%release
Provides: node.js = %version-%release
Obsoletes: nodejs < %version-%release
Obsoletes: node.js < %version-%release

Provides: nodejs(abi) = %{nodejs_abi}
Provides: nodejs(v8-abi) = %{v8_abi}
Provides: nodejs(napi) = 6
Provides: nodejs(napi) = %{napi}

Provides: bundled(llhttp) = 2.1.3
Provides: bundled(uvwasi) = 0.0.11

# /usr/bin/ld.default: failed to set dynamic section sizes: memory exhausted
%ifarch %ix86
%define optflags_debug -g0
%endif

# use no more than system_memory/1400 build procs (see https://bugzilla.altlinux.org/show_bug.cgi?id=35112)
%_tune_parallel_build_by_procsize 1400

%add_findreq_skiplist %{_datadir}/node/sources/*

%description
Node.js is a server-side JavaScript environment that uses an asynchronous
event-driven model.  Node's goal is to provide an easy way to build scalable
network programs.

%package devel
Summary:        Devel package for Node.js
Group:          Development/Other
License:        MIT license
# arch depended info in .gypi
#BuildArch:      noarch
Provides:	nodejs-devel = %version-%release
Requires:	%name = %version
Requires:       gcc-c++ zlib-devel libcares-devel
%if_with systemv8
Requires:	%libv8_package-devel >= %{v8_abi}
%endif
%if_with systemssl
Requires:	openssl-devel >= %openssl_version
%endif
%if_with systemuv
Requires: libuv-devel >= %libuv_abi
%else
Conflicts:      libuv-devel
%endif

%description devel
Node.js header and build tools


%package doc
Summary: Documentation files
Group: Development/Other
Requires: %name-devel = %version-%release

BuildArch: noarch

%description doc
Documentation files for %name.

# https://bugzilla.altlinux.org/show_bug.cgi?id=38130
%if_with npm
%package -n npm
Version:	%npmver
Group:		Development/Tools
Summary:	A package manager for node
License:	MIT License
Requires:	node
BuildArch:	noarch
AutoReq:	yes,nopython
# https://bugzilla.altlinux.org/show_bug.cgi?id=38130
#%if_with nodejs_abi
Requires:	nodejs(abi) = %{nodejs_abi}
#%endif

%description -n npm
npm is a package manager for node. You can use it to install and publish your
node programs. It manages dependencies and does other cool stuff.
%endif

%prep
%setup

%if_with systemv8
# hack against https://bugzilla.altlinux.org/show_bug.cgi?id=32573#c3
cp -a deps/v8/include/libplatform src
rm -rf deps/v8/
%endif

%if_with systemicu
rm -rf deps/icu-small/
%endif

%if_with systemuv
rm -rf deps/uv/
%__subst "s|deps/uv/uv.gyp ||" Makefile
%__subst "s|.*../uv/uv.gyp:libuv.*||" deps/uvwasi/uvwasi.gyp
%endif

%if_with systemnghttp2
rm -rf deps/nghttp2/
%endif

# disable external libs
# TODO:
# deps/gtest
rm -rf tools/gyp
rm -rf deps/zlib deps/openssl deps/cares
# make no sense for a first build
%__subst "s|deps/zlib/zlib.gyp||" Makefile


%if_without npm
#true
# don't use: keep internal npm (used for doc build)
rm -rf deps/npm/
ln -s %_libexecdir/node_modules/npm deps/npm
%endif

# use rpm's cflags
%__subst "s|'cflags': \[\],|'cflags': ['%optflags'],|" ./configure.py
# fix cflags wrap in outputted config.json
%__subst "s|indent=2|indent=2,width=160|" ./configure.py
# TODO: move to upstream?
%ifarch mipsel
%__subst "s|'libraries': \[\],|'libraries': ['-latomic'],|" ./configure.py
%endif

# override detected dir (detection via process.execPath does not work without /proc) with corect path
%__subst "s|path.resolve(prefixDir, 'lib', 'node')|'%nodejs_sitelib'|" lib/internal/modules/cjs/loader.js

%build
# hack against
# gyp: Error importing pymod_do_mainmodule (GN-scraper): No module named GN-scraper while loading dependencies of /tmp/.private/lav/RPM/BUILD/node-12.14.1/node.gyp
export PYTHONPATH=$(pwd)/tools/v8_gypfiles

./configure \
    --prefix=%_prefix \
    --shared-zlib \
%if_with systemicu
    --with-intl=system-icu \
%endif
%if_with systemhttpparser
    --shared-http-parser \
%endif
    --shared-cares \
%if_with systemssl
    --shared-openssl \
    --shared-openssl-includes=%_includedir \
%endif
%if_without npm
    --without-npm \
%endif
%if_with systemuv
    --shared-libuv \
%endif
%if_with systemnghttp2
    --shared-nghttp2
%endif
%if_with systemv8
    --without-bundled-v8
%endif

%make_build BUILDTYPE=Release
# skip internal doc build (uses external modules)
#make doc
#%make jslint

%check
%make_build test

%install
mkdir -p %buildroot%nodejs_sitelib/

%makeinstall_std

%if_without systemuv
#install development headers
mkdir -p %{buildroot}%{_includedir}/node/
cp -p src/*.h %{buildroot}%{_includedir}/node
cp -p deps/uv/include/*.h %{buildroot}%{_includedir}/node
#cp -p deps/uv/include/uv-private/*.h %{buildroot}%{_includedir}/node/uv-private
%endif

%if_with npm
#node-gyp needs common.gypi too
mkdir -p %{buildroot}%{_datadir}/node
cp -p common.gypi %{buildroot}%{_datadir}/node
#tar -xf %{SOURCE0} --directory=%{buildroot}%{_datadir}/node/sources
%endif

%if_with nodejs_abi
# ensure Requires are added to every native module that match the Provides from
# the nodejs build in the buildroot
install -Dpm0755 %{SOURCE7} %buildroot%_rpmlibdir/nodejs_native.req.files
cat << EOF > %buildroot%_rpmlibdir/nodejs_native.req
#!/bin/sh
echo 'nodejs(abi) = %nodejs_abi'
echo 'nodejs(v8-abi) = %v8_abi'
EOF
chmod 0755 %buildroot%_rpmlibdir/nodejs_native.req
%endif

rm -rf %buildroot/usr/lib/dtrace/
rm -rf %buildroot/usr/share/doc/node/gdbinit
rm -rf %buildroot/usr/share/doc/node/lldb_commands.py
rm -rf %buildroot/usr/share/doc/node/lldbinit


# drop tapset file
rm -rf %buildroot%_datadir/systemtap/tapset

# pack node include tarball required to gyp building
#mkdir -p %name-v%version/include/
#cp -rp %buildroot%_includedir/%name %name-v%version/include/
#mkdir -p %buildroot%_datadir/node/
#tar -zcf %buildroot%_datadir/%name/%name-v%version-headers.tar.gz %name-v%version

#ln -s node_modules %buildroot%_prefix/lib/node

%files
%doc AUTHORS CHANGELOG.md LICENSE README.md
%_bindir/node
%dir %nodejs_sitelib
#_prefix/lib/node
#%_datadir/systemtap/tapset/node.stp
%_man1dir/*

%files doc
%doc README.md
#out/doc/api

%files devel
%dir %_includedir/node/
#%_datadir/%name/%name-v%version-headers.tar.gz
%if_without systemuv
%_includedir/node/uv*
%endif
%if_without systemv8
%_includedir/node/v8*
%endif
%_includedir/node/node*
%_includedir/node/js_native_api*
# deps/cares
#_includedir/node/ares*
%_includedir/node/common.gypi
%_includedir/node/config.gypi
%_includedir/node/libplatform/
%_includedir/node/cppgc/
# deps/http_parser
#_includedir/node/nameser.h
#_datadir/node/common.gypi
%if_with nodejs_abi
%_rpmlibdir/nodejs_native.req
%_rpmlibdir/nodejs_native.req.files
%endif
#%_datadir/node/sources

%if_with npm
%files -n npm
%_bindir/npm
%nodejs_sitelib/npm/
%exclude %_libexecdir/node_modules/npm/node_modules/node-gyp/gyp/tools/emacs
%endif

%changelog
