%def_enable perl
%def_enable python
%def_enable ruby
%def_disable tcl
%def_disable static
%def_disable swig

%if_enabled perl
%force_enable swig
%endif
%if_enabled python
%force_enable swig
%endif
%if_enabled ruby
%force_enable swig
%endif
%if_enabled tcl
%force_enable swig
%endif

Summary: ObexFTP implements the Object Exchange (OBEX) protocols file transfer
Name: obexftp
Version: 0.24.2
Release: alt2.4

License: GPLv2
Group: Communications
URL: https://sourceforge.net/projects/openobex/

Source: %name-%version.tar

# Patches from Fedora
Patch0: %name-norpath.patch
Patch1: %name-0.24-fix-absurd-install-path.patch

# ALT Linux patches
Patch2: %name-alt-fix-library-link.patch

Requires: lib%name = %version-%release

BuildRequires(pre): cmake
BuildRequires: gcc-c++ libopenobex-devel libgsm-devel libbluez-devel
BuildRequires: libusb-compat-devel libfuse-devel asciidoc xmlto
BuildRequires: libexpat-devel

BuildPreReq: chrpath

%if_enabled swig
BuildRequires: swig
%endif
%if_enabled perl
BuildRequires: perl-devel
%endif
%if_enabled python
BuildRequires: python-devel
%endif
%if_enabled ruby
BuildRequires: ruby libruby-devel
%endif
%if_enabled tcl
BuildRequires: tcl-devel tcl
%endif

%package -n lib%name
Summary: obexftp libraries
Group: System/Libraries

%package devel
Summary: Development files of obexftp
Group: Development/C
Requires: lib%name = %version-%release

%if_enabled static
%package devel-static
Summary: Static develop path of obexftp
Group: Development/C
Requires: lib%name-devel = %version-%release
%endif

%if_enabled python
%package -n python-module-obexftp
Summary: Python bindings for obexftp
Group: Development/Python
%endif

%if_enabled perl
%package -n perl-obexftp
Summary: Perl bindings for obexftp
Group: Development/Perl
%endif

%if_enabled tcl
%package -n tcl-obexftp
Summary: Tcl bindings for obexftp
Group: Development/Tcl
Requires: tcl
%endif

%if_enabled ruby
%package -n ruby-obexftp
Summary: Ruby bindings for obexftp
Group: Development/Ruby
Requires: ruby
%endif

%description
This package contains some command line tools and the ObexFTP library.
Using OpenOBEX it enables you to transfer data via IrDA, BlueTooth
as well as some custom (Siemens, Ericsson) serial port protocols.
Authors: Christian W. Zuckschwerdt <zany@triq.net>

%description -n lib%name
Libraries for obexftp

%description devel
This package contains some command line tools and the ObexFTP library.
Using OpenOBEX it enables you to transfer data via IrDA, BlueTooth
as well as some custom (Siemens, Ericsson) serial port protocols.

%if_enabled static
%description devel-static
Static development files for obexftp.
%endif

%if_enabled python
%description -n python-module-obexftp
Python bindings for obexftp.
%endif

%if_enabled perl
%description -n perl-obexftp
Perl bindings for obexftp.
%endif

%if_enabled tcl
%description -n tcl-obexftp
Tcl bindings for obexftp.
%endif

%if_enabled ruby
%description -n ruby-obexftp
Ruby bindings for obexftp.
%endif

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p2

%build
%cmake
%cmake_build all doc RUBY="ruby -rvendor-specific"

%install
%cmakeinstall_std

%if_enabled ruby
install -Dm 0755 %buildroot/usr/lib/ruby/vendor_ruby/*/*/obexftp.so %buildroot%ruby_sitearchdir/obexftp.so
rm -f %buildroot/usr/lib/ruby/vendor_ruby/*/*/obexftp.so
%endif

%files
%doc AUTHORS ChangeLog NEWS README* THANKS TODO
%_bindir/*
%_man1dir/*

%files -n lib%name
%_libdir/lib*.so.*

%files devel
%dir %_includedir/bfb
%dir %_includedir/multicobex
%dir %_includedir/obexftp
%_includedir/*/*
%_libdir/*.so
%_pkgconfigdir/obexftp.pc
%if_enabled tcl
%_tcldatadir/*
%endif

%if_enabled static
%files devel-static
%_libdir/lib*.a
%endif

%if_enabled perl
%files -n perl-obexftp
%perl_vendor_archlib/OBEXFTP*
%perl_vendor_autolib/OBEXFTP*
%endif

%if_enabled python
%files -n python-module-obexftp
%python_sitelibdir/*
%endif

%if_enabled tcl
%files -n tcl-obexftp
%_tcllibdir/*
%_tcldatadir/*
%endif

%if_enabled ruby
%files -n ruby-obexftp
%ruby_sitearchdir/*
%endif

%changelog
