Name: ocaml-lablgl
Version: 1.05
Release: alt7
Summary: OpenGL library for OCaml
License: BSD-style
Group: Development/ML
Url: https://forge.ocamlcore.org/projects/lablgl/
# git https://forge.ocamlcore.org/anonscm/git/lablgl/lablgl.git
Source: %name-%version.tar

Provides: %name-runtime = %version-%release
Obsoletes: %name-runtime < %version-%release
Provides: lablGL = %version-%release
Obsoletes: lablGL

BuildRequires: ocaml-camlp4-devel ocaml-labltk libXext-devel libXmu-devel libGLUT-devel tcl-togl-devel
BuildRequires: libXxf86vm-devel
BuildRequires(pre): rpm-build-tcl

%description
LablGL is an OpenGL interface for Objective Caml.  It includes two
interfaces: the Togl widget, for comfortable use with LablTk, and
LablGlut for standalone applications not using Tcl/Tk.


%package devel
Summary: Development files for %name
Requires: %name = %version-%release
Requires: ocaml-labltk
Group: Development/ML

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup
cat > Makefile.config <<EOF
CAMLC = ocamlc.opt
CAMLOPT = ocamlopt.opt
BINDIR = %_bindir
XINCLUDES =
XLIBS = -lXext -lXmu -lX11
TKINCLUDES = -I%_includedir
GLINCLUDES =
GLLIBS = -lGL -lGLU
GLUTLIBS = -lglut -lXxf86vm
RANLIB = :
LIBDIR = %_libdir/ocaml
DLLDIR = %_libdir/ocaml/stublibs
INSTALLDIR = %_libdir/ocaml/lablGL
TOGLDIR=Togl
COPTS = $RPM_OPT_FLAGS
EOF

%build
make all opt INSTALLDIR=%_libdir/ocaml/lablGL \
	TCLLIBDIR=%_tcllibdir TOGLVERSION=%{get_version tcl-togl}

%install
mkdir -p %buildroot%_libdir/ocaml/stublibs
mkdir -p %buildroot%_bindir
%make_install install \
	INSTALLDIR=%buildroot%_libdir/ocaml/lablGL \
	DLLDIR=%buildroot%_libdir/ocaml/stublibs \
	BINDIR=%buildroot%_bindir

# Make and install a META file.
cat <<EOM >META
version="%version"
directory="+lablgl"
archive(byte) = "lablgl.cma"
archive(native) = "lablgl.cmxa"

package "togl" (
  requires = "labltk lablgl"
  archive(byte) = "togl.cma"
  archive(native) = "togl.cmxa"
)

package "glut" (
  requires = "lablgl"
  archive(byte) = "lablglut.cma"
  archive(native) = "lablglut.cmxa"
)
EOM
install -p -m644 META %buildroot%_libdir/ocaml/lablGL/META

%files
%doc CHANGES COPYRIGHT README Togl/examples/ LablGlut/examples/
%dir %_libdir/ocaml/lablGL
%_libdir/ocaml/lablGL/*.cma
%_libdir/ocaml/lablGL/*.cmi
%_libdir/ocaml/stublibs/*.so
%_bindir/lablgl
%_bindir/lablglut

%files devel
%doc CHANGES COPYRIGHT README LablGlut/examples Togl/examples
%_libdir/ocaml/lablGL/META
%_libdir/ocaml/lablGL/*.mli
%_libdir/ocaml/lablGL/*.cmxa
%_libdir/ocaml/lablGL/*.cmx
%_libdir/ocaml/lablGL/*.a
%_libdir/ocaml/lablGL/build.ml
%exclude %_libdir/ocaml/lablGL/gl*.ml
%exclude %_libdir/ocaml/lablGL/raw.ml
%exclude %_libdir/ocaml/lablGL/togl.ml

%changelog
