%define Name iSCSI
%define bname iscsi

Name: open-%bname
%define module_name %name
Version: 2.1.4
License: GPL-2.0-or-later
Release: alt3
Summary: Utils to operate with %Name
Group: System/Kernel and hardware
URL: http://%name.org
Source: %name-%version.tar
Source1: iscsi-gen-initiatorname.sh
Patch: %name-%version-%release.patch
Conflicts: linux-iscsi
Provides: iscsi-initiator-utils = 6.%version-%release

BuildRequires: libmount-devel
BuildRequires: libkmod-devel
BuildRequires: libssl-devel
BuildRequires: libsystemd-devel
BuildRequires: libisns-devel

%description
The Open-iSCSI project is a high-performance, transport independent,
multi-platform implementation of RFC3720 iSCSI.

%package iscsiuio
Summary: Userspace configuration daemon required for some iSCSI hardware
Group: System/Kernel and hardware
License: BSD
Requires: %name = %version-%release

%description iscsiuio
The iscsiuio configuration daemon provides network configuration help
for some iSCSI offload hardware.

%package -n libopeniscsiusr
Summary: library providing access to Open-iSCSI initiator functionality
Group: System/Libraries
License: BSD

%description -n libopeniscsiusr
The libopeniscsiusr library provides a C API for access to the Open-iSCSI
initiator. It is used by the Open-iSCSI command line tools.

%package -n libopeniscsiusr-devel
Summary: Development files for libopeniscsiusr
Group: Development/C
Requires: libopeniscsiusr = %EVR

%description -n libopeniscsiusr-devel
The libopeniscsiusr-devel package contains libraries and header files for
developing applications that use libopeniscsiusr.

%prep
%setup
%patch -p1

%build
# configure sub-packages from here
# letting the top level Makefile do it will lose setting from rpm
cd iscsiuio
%autoreconf
%configure --disable-static
cd ..

%make_build

%install
%make_install DESTDIR=%buildroot initddir=%_initdir \
    install_programs install_initd_alt install_etc install_doc install_libopeniscsiusr

install -m 0755 %SOURCE1 %buildroot/sbin/iscsi-gen-initiatorname

install -d %buildroot%_lockdir/iscsi
touch %buildroot%_lockdir/iscsi/lock

install -pm 755 usr/iscsistart %buildroot/sbin/
install -pm 644 doc/iscsistart.8 %buildroot%_man8dir/
install -pm 644 doc/iscsi-iname.8 %buildroot%_man8dir/
install -d %buildroot%_logrotatedir
install -pm 644 iscsiuio/iscsiuiolog %buildroot%_logrotatedir/

mkdir -p %buildroot%_sharedstatedir/%bname/{nodes,send_targets,static,isns,slp,ifaces}

install -d %buildroot%_unitdir
install -pm 644 etc/systemd/iscsi-init.service %buildroot%_unitdir/
install -pm 644 etc/systemd/iscsi.service %buildroot%_unitdir/
install -pm 644 etc/systemd/iscsid.service %buildroot%_unitdir/
install -pm 644 etc/systemd/iscsid.socket %buildroot%_unitdir/
install -pm 644 etc/systemd/iscsiuio.service %buildroot%_unitdir/
install -pm 644 etc/systemd/iscsiuio.socket %buildroot%_unitdir/
install -d %buildroot%_tmpfilesdir
install -pm 644 etc/systemd/iscsi.tmpfiles %buildroot%_tmpfilesdir/%bname.conf

ln -s iscsid.service %buildroot%_unitdir/open-iscsi.service

%post
if [ ! -f /etc/iscsi/initiatorname.iscsi ] ; then
    /sbin/iscsi-gen-initiatorname
fi
%post_service %name

%preun
%preun_service %name

%post iscsiuio
%post_service iscsiuio

%preun iscsiuio
%preun_service iscsiuio

%files
%doc README THANKS etc/iface.example
%dir %_sysconfdir/%bname
%config(noreplace) %_sysconfdir/%bname/%{bname}d.conf
%_sharedstatedir/%bname
%_initdir/*
%_tmpfilesdir/*
%_unitdir/*
%exclude %_unitdir/iscsiuio.*
/sbin/*
%exclude /sbin/iscsiuio
%_man8dir/*
%exclude %_man8dir/iscsiuio.8.*
%dir %_lockdir/iscsi
%ghost %_lockdir/iscsi/lock

%files iscsiuio
/sbin/iscsiuio
%_unitdir/iscsiuio.*
%config(noreplace) %_logrotatedir/iscsiuiolog
%_man8dir/iscsiuio.8.*

%files -n libopeniscsiusr
%_libdir/libopeniscsiusr.so.*

%files -n libopeniscsiusr-devel
%_libdir/libopeniscsiusr.so
%_includedir/*
%_pkgconfigdir/libopeniscsiusr.pc

%changelog
