
%def_without lapack
%ifnarch %e2k
%def_enable dynamic_arch
%endif

Name: openblas
Version: 0.3.9
Release: alt2

Summary: Optimized BLAS library based on GotoBLAS2 1.13 
License: BSD
Group: Sciences/Mathematics
Url: https://github.com/xianyi/OpenBLAS

# http://github.com/xianyi/OpenBLAS
Source: %name-%version.tar
Patch2000: %name-e2k.patch

BuildRequires: gcc-fortran
%ifarch ppc64le
BuildRequires: libgomp-devel
%endif

%description
GotoBLAS2 has been released by the Texas Advanced Computing Center as
open source software under the BSD license. This product is no longer
under active development by TACC, but it is being made available to the
community to use, study, and extend. GotoBLAS2 uses new algorithms and
memory techniques for optimal performance of the BLAS routines. The
changes in this final version target new architecture features in
microprocessors and interprocessor communication techniques; also, NUMA
controls enhance multi-threaded execution of BLAS routines on node.

OpenBLAS is an optimized BLAS library based on GotoBLAS2 1.13 BSD
version. OpenBLAS is an open source project supported by Lab of Parallel
Software and Computational Science, ISCAS.

%package -n lib%name
Summary: Shared library of GotoBLAS2
Group: System/Libraries

%description -n lib%name
GotoBLAS2 has been released by the Texas Advanced Computing Center as
open source software under the BSD license. This product is no longer
under active development by TACC, but it is being made available to the
community to use, study, and extend. GotoBLAS2 uses new algorithms and
memory techniques for optimal performance of the BLAS routines. The
changes in this final version target new architecture features in
microprocessors and interprocessor communication techniques; also, NUMA
controls enhance multi-threaded execution of BLAS routines on node.

OpenBLAS is an optimized BLAS library based on GotoBLAS2 1.13 BSD
version. OpenBLAS is an open source project supported by Lab of Parallel
Software and Computational Science, ISCAS.

This package contains shared library of OpenBLAS.

%package -n lib%name-devel
Summary: Development files of GotoBLAS2
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-devel
GotoBLAS2 has been released by the Texas Advanced Computing Center as
open source software under the BSD license. This product is no longer
under active development by TACC, but it is being made available to the
community to use, study, and extend. GotoBLAS2 uses new algorithms and
memory techniques for optimal performance of the BLAS routines. The
changes in this final version target new architecture features in
microprocessors and interprocessor communication techniques; also, NUMA
controls enhance multi-threaded execution of BLAS routines on node.

OpenBLAS is an optimized BLAS library based on GotoBLAS2 1.13 BSD
version. OpenBLAS is an open source project supported by Lab of Parallel
Software and Computational Science, ISCAS.

This package contains development files of OpenBLAS.

%prep
%setup
%ifarch %e2k
%patch2000 -p1
%endif

%build
FLAGS="%optflags %optflags_shared"

# FC/CC - path to compiler
# F_COMPILER/C_COMPILER - compiler type (GCC, CLANG, GFORTRAN, etc.)
# COMMON_OPT - compiler options
FC="gfortran" F77="g77" CC="gcc" \
F_COMPILER="GFORTRAN" C_COMPILER="GCC" \
%make_build SMP=1 \
%if "%_lib" == "lib64"
	BINARY=64 \
%else
	BINARY=32 \
%endif
%ifarch armh
	TARGET=ARMV7 \
%endif
%ifarch aarch64
	TARGET=ARMV8 \
%endif
	COMMON_OPT="$FLAGS" \
	%{?_enable_dynamic_arch:DYNAMIC_ARCH=1} \
	ALLOC_HUGETLB=1 \
	%{?_without_lapack:NO_LAPACK=1} \
	%{nil}

%install
%make_install OPENBLAS_LIBRARY_DIR=%buildroot%_libdir \
	      OPENBLAS_INCLUDE_DIR=%buildroot%_includedir/openblas \
	      install
sed -i 's,%buildroot,,' %buildroot%_pkgconfigdir/openblas.pc

%check
make tests \
	%{?_enable_dynamic_arch:DYNAMIC_ARCH=1} \
	%{?_without_lapack:NO_LAPACK=1} \
	%{nil}

%files -n lib%name
%doc README* *.txt
%_libdir/*-r*.so
%_libdir/*.so.*

%files -n lib%name-devel
%exclude %_libdir/*-r*.so
%_libdir/*.so
%_pkgconfigdir/openblas.pc
%_includedir/openblas

%changelog
