Name: openssl-gost-engine
Version: 1.1.0.3.0.255.ge3af41d.p1
Release: alt3

License: BSD-style
Summary: A reference implementation of the Russian GOST crypto algorithms for OpenSSL

Group: System/Libraries

Source: %name-%version.tar
Source1: openssl-gost.control

Patch0: %name-1.1.0.3.0.255.ge3af41d-mac-iv.patch
Patch1: %name-1.1.0.3.0.255.ge3af41d-gost89-ecb.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
# due to gost algorithms identifiers (in headers)
BuildRequires: libssl-devel >= 1.1.0j-alt2

%{?!_without_check:%{?!_disable_check:BuildRequires: ctest perl-devel perl-Test2-Suite openssl}}

# due to gost algorithms identifiers (inside libcrypto)
Requires: libcrypto1.1 >= 1.1.0j-alt2

%description
A reference implementation of the Russian GOST crypto algorithms for OpenSSL.

%package -n gostsum
Summary: GOST file digesting utilites
Group: File tools

%description -n gostsum
GOST file digesting utilites.

%prep
%setup
%patch0 -p1
%patch1 -p1

%build
%ifarch %e2k
# lcc 1.23.12: test_curves.c: if ((test = (e)))
%add_optflags -Wno-error=assign-where-compare-meant
%endif
%cmake \
	#

%cmake_build

%install
enginesdir="$(pkg-config --variable=enginesdir libcrypto)"
mkdir -p %buildroot%_bindir
mkdir -p %buildroot%_man1dir
mkdir -p %buildroot$enginesdir

cp BUILD/bin/gost.so %buildroot$enginesdir/
cp BUILD/bin/gost*sum %buildroot%_bindir/
cp gost*sum.1 %buildroot%_man1dir/

# Install the control scripts
install -D -p -m0755 %_sourcedir/openssl-gost.control \
        %buildroot%_controldir/openssl-gost

%check
CTEST_OUTPUT_ON_FAILURE=1 \
	make test -C BUILD ARGS="--verbose"

%files
%_libdir/openssl/engines-1.1/gost.so
%_controldir/openssl-gost

%files -n gostsum
%_bindir/gost*sum*
%_man1dir/gost*sum*

%changelog
