# spec file for package openvpn (Version 2.3)
#

%define _name openvpn

%def_with systemd
%def_with plugins
%def_without devel
%def_with syslog

%def_with management
%def_with pkcs11
%def_with http_proxy
%def_with socks
%def_with multihome
%def_with port_share
%def_with x509_alt_username

Name: %_name-gostcrypto
Version: 2.4.9
Release: alt2

Summary: a full-featured SSL VPN solution with GOST algorithms
Summary(ru_RU.UTF-8): полнофункциональное решение VPN на базе SSL с ГОСТ алгоритмами

License: GPL-2.0-only
Group: System/Servers
Url: http://www.openvpn.net

Source0: %name-%version.tar
Patch0:  %name-%version-%release.patch

Patch1:  %_name-2.4.2-alt-pkcs11_pin_prompt.patch

Source1: %_name.init
Source2: %_name-startup
Source3: %_name.sysconfig
Source4: %_name.chroot.lib
Source5: %_name.chroot.conf
Source6: %_name.chroot.all
Source7: %_name-README.ALT.utf-8
Source8: %_name-server.conf
Source9: %_name-client.conf
Source10: %_name.tmpfiles

# Because of /etc/syslog.d/ feature
Conflicts: syslogd < 1.4.1-alt11

# Automatically added by buildreq on Mon Nov 16 2020
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 libgpg-error libpkcs11-helper libssl-devel perl pkg-config python-modules python2-base python3 python3-base python3-module-paste ruby ruby-stdlibs sh4
BuildRequires: cmake git-core glibc-devel-static iproute2 liblz4-devel liblzo2-devel libselinux-devel net-tools

%{?_with_systemd:BuildRequires: libsystemd-devel}
%{?_with_pkcs11:BuildRequires: pkcs11-helper-devel}
%{?_with_plugins:BuildRequires: libpam-devel}

Conflicts: %_name
Provides: %_name = %version-%release

%description
OpenVPN is a full-featured SSL VPN solution which can accomodate
a wide range  of configurations,  including road warrior access,
home/office/campus  telecommuting,  WiFi security, secure branch
office  linking,  and enterprise-scale  remote access  solutions
with load balancing, failover, and fine-grained access-controls.

This varriant includes GOST algorithms support.

%description -l ru_RU.UTF-8
OpenVPN  -  полнофункциональное решение для VPN с использованием
SSL, с помощью которого можно решить широкий круг задач, включая
подключения  для удалённых  пользователей,  телекоммуникации для
дома и офиса,  безопасные  подключения  для  беспроводных сетей,
безопасную связь  с удалёнными офисами,  решения  для удалённого
доступа масштаба предприятий с поддержкой балансировки нагрузки,
отказоустойчивости и четко разграниченным контролем доступа.

Этот вариант включает в себя поддержку ГОСТ алгоритмов.

%if_with plugins
%package -n %_name-plugins-gostcrypto
Summary: external plugins for OpenVPN
Summary(ru_RU.UTF-8): внешние расширения для OpenVPN
Group: System/Servers
Requires: %name = %version-%release
Conflicts: %_name-plugins
Provides: %_name-plugins = %version-%release

%description -n %_name-plugins-gostcrypto
OpenVPN is a full-featured SSL VPN solution.
This package contains OpenVPN plugins for user authentication
via PAM and to allow run a down script with root privileges.

%description -n %_name-plugins-gostcrypto -l ru_RU.UTF-8
OpenVPN - полнофункциональное решение для VPN на базе SSL.
Данный пакет содержит расширения (plugins) для авторизации
пользователей через  PAM и  запуска при разрыве соединений
скрипта с привилегиями root.
%endif

%package -n %_name-docs-gostcrypto
Summary: OpenVPN documentation
Summary(ru_RU.UTF-8): документация к OpenVPN
Group: System/Servers
Requires: %name = %version-%release
Conflicts: %_name-docs
Provides: %_name-docs = %version-%release

%description -n %_name-docs-gostcrypto
OpenVPN is a full-featured SSL VPN solution.

This package contains OpenVPN documentation,
sample configs and scripts.

%description -n %_name-docs-gostcrypto -l ru_RU.UTF-8
OpenVPN - полнофункциональное решение для VPN на базе SSL.

Данный пакет содержит документацию, примеры конфигурации и
скриптов для OpenVPN.

%if_with devel
%package -n %_name-devel-gostcrypto
Summary: Headers for OpenVPN plugins
Group: Development/C
Requires: %name = %version-%release
Conflicts: %_name-devel
Provides: %_name-devel = %version-%release

%description -n %_name-devel-gostcrypto
OpenVPN is a full-featured SSL VPN solution.

This package contains OpenVPN header file
for third-party plugin development.
%endif


%define openvpn_root   %_localstatedir/%_name
%define openvpn_cache  %openvpn_root/cache
%define ovpn_user      openvpn
%define ovpn_group     openvpn

%define _unpackaged_files_terminate_build 1

%prep
%setup -n %name-%version
%patch0 -p1

%patch1 -p1

cp -- %SOURCE7 README.ALT.utf-8
cp -- %SOURCE8 server.conf
cp -- %SOURCE9 client.conf

%build
%autoreconf

# Systemd password request utility and systemd directories:
%if_with systemd
export SYSTEMD_ASK_PASSWORD=/sbin/systemd-ask-password
export TMPFILES_DIR=%_tmpfilesdir
export SYSTEMD_UNIT_DIR=%_unitdir
cp -f -- %SOURCE10 distro/systemd/tmpfiles-openvpn.conf
%endif

%configure \
    --enable-iproute2 \
    --with-iproute-path=/sbin/ip \
    --enable-password-save \
    --enable-lzo \
    %{?_with_plugins:--enable-plugins --enable-plugin-auth-pam --enable-plugin-down-root} \
    %{?_with_management:--enable-management} \
    %{?_with_pkcs11:--enable-pkcs11} \
    %{?_with_socks:--enable-socks} \
    %{?_with_http_proxy:--enable-http-proxy} \
    %{?_with_multihome:--enable-multihome} \
    %{?_with_port_share:--enable-port-share} \
    %{?_with_x509_alt_username:--enable-x509-alt-username} \
    %{?_with_systemd:--enable-systemd} \
    %nil

%make_build
subst 's|nobody|%ovpn_user|' sample/sample-config-files/*

%if_with plugins
# Building 'simple' plugin
pushd sample/sample-plugins/simple
CPPFLAGS="${CPPFLAGS:--I../../../include}" ./build simple
mv -- simple.so %_name-plugin-simple.so
popd

# Building 'defer' plugin
pushd sample/sample-plugins/defer
CPPFLAGS="${CPPFLAGS:--I../../../include}" ./build simple
mv -- simple.so %_name-plugin-defer.so
popd

# Building 'log_v3' plugin
pushd sample/sample-plugins/log
CPPFLAGS='-I../../../include' ./build log_v3
mv -- log_v3.so %_name-plugin-log.so
popd
%endif

%ifndef __BTE
   # make check hangs inside hasher
   make check
%endif

%install
%make_install DESTDIR=%buildroot install

# Removing automatically installed docs
rm -rf -- %buildroot%_datadir/doc/%_name

# Gzip ChangeLog
gzip ChangeLog

# Configuration
install -m 0750 -d -- %buildroot%_sysconfdir/%_name
install -m 0750 -d -- %buildroot%_sysconfdir/%_name/keys
install -m 0750 -d -- %buildroot%_sysconfdir/%_name/client
install -m 0750 -d -- %buildroot%_sysconfdir/%_name/server
ln -s -- ../..%openvpn_root%_sysconfdir/%_name/ccd  %buildroot%_sysconfdir/%_name/ccd

# Chroot environment
install -m 0755 -d -- %buildroot%openvpn_root
install -m 0755 -d -- %buildroot%openvpn_root%_sysconfdir
install -m 0755 -d -- %buildroot%openvpn_root/%_lib
install -m 0755 -d -- %buildroot%openvpn_root%_sysconfdir/%_name
install -m 0755 -d -- %buildroot%openvpn_root%_sysconfdir/%_name/ccd
install -m 0755 -d -- %buildroot%openvpn_root/tmp
install -m 0755 -d -- %buildroot%openvpn_cache

# SysInit and systemd startup scripts
mkdir -p -- %buildroot/%_initdir
mkdir -p -- %buildroot/%_sysconfdir/sysconfig
install -m 0755 -- %SOURCE1 %buildroot%_initdir/%_name
install -m 0750 -- %SOURCE2 %buildroot%_sysconfdir/%_name
install -m 0640 -- %SOURCE3 %buildroot%_sysconfdir/sysconfig/%_name

# update_chrooted files
install -p -m 0750 -D -- %SOURCE4 %buildroot%_sysconfdir/chroot.d/%_name.lib
install -p -m 0750 -D -- %SOURCE5 %buildroot%_sysconfdir/chroot.d/%_name.conf
install -p -m 0750 -D -- %SOURCE6 %buildroot%_sysconfdir/chroot.d/%_name.all

mv -f -- COPYRIGHT.GPL COPYRIGHT.GPL.orig
ln -s -- $(relative %_licensedir/GPL-2 %_docdir/%_name/COPYRIGHT.GPL) COPYRIGHT.GPL

%if_with plugins
# Install plugins
for pi in defer log simple; do
    [ -f sample/sample-plugins/$pi/README ] && \
        mv -f -- sample/sample-plugins/$pi/README sample/sample-plugins/README.$pi
    [ -x sample/sample-plugins/$pi/%_name-plugin-$pi.so ] && \
        install -c -m 0755 -- sample/sample-plugins/$pi/%_name-plugin-$pi.so %buildroot%_libdir/%_name/plugins/%_name-plugin-$pi.so
done

mkdir -- plugins
mv -f -- doc/README.plugins  plugins/README.plugins
mv -f -- sample/sample-plugins/README* plugins/
%endif

%if_with syslog
# Make use of syslogd-1.4.1-alt11 /etc/syslog.d/ feature.
mkdir -p -- %buildroot%openvpn_root/dev
/usr/bin/mksock %buildroot%openvpn_root/dev/log
mkdir -p -m700 -- %buildroot%_sysconfdir/syslog.d
ln -s -- %openvpn_root/dev/log %buildroot%_sysconfdir/syslog.d/%_name
%endif

%pre
# Add the "openvpn" user
%_sbindir/groupadd -r -f %ovpn_group 2>/dev/null ||:
%_sbindir/useradd  -r -g %ovpn_group -c 'OpenVPN daemon' \
        -s /dev/null -d /dev/null %ovpn_user 2>/dev/null ||:

%post
%_sysconfdir/chroot.d/%_name.all
%post_service %_name

%preun
%preun_service %_name


%files
%doc AUTHORS CONTRIBUTING.rst ChangeLog.gz PORTS README COPYING
%doc README.IPv6 TODO.IPv6
%doc --no-dereference COPYRIGHT.GPL
%doc README.ALT.utf-8 server.conf client.conf
%if_with management
%doc doc/management-notes.txt
%endif

%_sbindir/%_name
%_mandir/man?/*

%attr(0750,root,%ovpn_group) %dir %_sysconfdir/%_name
%attr(0750,root,%ovpn_group) %dir %_sysconfdir/%_name/keys
                                  %_sysconfdir/%_name/ccd
%attr(0750,root,%ovpn_group) %dir %_sysconfdir/%_name/client
%attr(0750,root,%ovpn_group) %dir %_sysconfdir/%_name/server
%attr(0750,root,%ovpn_group) %dir %openvpn_root
                             %dir %openvpn_root/etc
                             %dir %openvpn_root/etc/openvpn
                             %dir %openvpn_root/etc/openvpn/ccd
%attr(0770,root,%ovpn_group) %dir %openvpn_root/tmp
                             %dir %openvpn_root/%_lib
%attr(0750,%ovpn_user,%ovpn_group) %dir %openvpn_cache

%config(noreplace)  %_sysconfdir/%_name/%_name-startup
%config(noreplace)  %_sysconfdir/sysconfig/%_name
%config             %_sysconfdir/chroot.d/%_name.*
%config             %_initdir/%_name

%if_with systemd
%_unitdir/%_name-*.service
%_tmpfilesdir/%_name.conf
%endif

%if_with syslog
%attr(0710,root,%ovpn_group) %dir %openvpn_root/dev
%ghost %attr(0666,root,root)      %openvpn_root/dev/log

%_sysconfdir/syslog.d/%_name
%endif


%if_with plugins
%files -n %_name-plugins-gostcrypto
%doc plugins/*
%doc src/plugins/*/README.*
%dir %_libdir/%_name
%dir %_libdir/%_name/plugins
     %_libdir/%_name/plugins/%_name-*.so
%exclude %_libdir/%_name/plugins/%_name-*.la
%endif

%files -n %_name-docs-gostcrypto
%doc INSTALL
%doc sample/sample-config-files*
%doc sample/sample-keys*
%doc sample/sample-scripts*

%if_with devel
%files -n %_name-devel-gostcrypto

%_includedir/openvpn-plugin.h
%_includedir/openvpn-msg.h
%else
%exclude %_includedir/openvpn-plugin.h
%exclude %_includedir/openvpn-msg.h
%endif

%changelog
