%def_enable snapshot

%define ver_major 0.4
%def_enable gtk_doc
%def_enable check

%ifarch %valgrind_arches
%def_enable valgrind
%endif

Name: orc
Version: %ver_major.30.1
Release: alt0.3

Summary: The Oil Runtime Compiler
Group: Development/Other
License: BSD
URL: http://code.entropywave.com/projects/orc/

%if_disabled snapshot
Source: https://gstreamer.freedesktop.org/src/orc/%name-%version.tar.xz
%else
# VCS: https://anongit.freedesktop.org/gstreamer/orc
Source: %name-%version.tar
%endif

BuildRequires(pre): meson rpm-macros-valgrind /proc
BuildRequires: glib2-devel >= 2.10.0 gtk-doc
%{?_enable_valgrind:BuildRequires: valgrind-devel}

%description
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

%package -n lib%name
Summary: The Oil Runtime Compiler library
Group: System/Libraries

%description -n lib%name
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

This package contains the Orc library.

%package -n lib%name-devel
Summary: Development files for liborc
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

This package contains development files for the Orc library.

%package -n lib%name-test
Summary: The Oil Runtime Compiler library
Group: System/Libraries

%description -n lib%name-test
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

This package contains the Orc test library.

%package -n lib%name-test-devel
Summary: Development test files for liborc
Group: Development/C
Requires: lib%name-test = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-test-devel
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

This package contains development files for the Orc test library.

%package doc
Summary: Dcumentation for Orc
Group: Development/Documentation
BuildArch: noarch

%description doc
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

This package contains documentation for Orc.

%prep
%setup
%ifarch %arm aarch64 
# oficially broken on arm arches
# https://gitlab.freedesktop.org/gstreamer/orc/-/issues/20
# https://gitlab.freedesktop.org/gstreamer/orc/-/issues/33
sed -i /exec_opcodes_sys/d testsuite/meson.build
%endif

%build
%meson \
    %{?_enable_gtk_doc:-Dgtk_doc=enabled}
%nil
%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files
%_bindir/%name-bugreport
%_bindir/%{name}c

%files -n lib%name
%_libdir/lib%name-%ver_major.so.*

%files -n lib%name-test
%_libdir/lib%name-test-%ver_major.so.*

%files -n lib%name-devel
%dir %_includedir/%name-%ver_major
%_includedir/%name-%ver_major/orc
%_libdir/lib%name-%ver_major.so
%_pkgconfigdir/%name-%ver_major.pc
%_datadir/aclocal/%name.m4

%files -n lib%name-test-devel
%_includedir/%name-%ver_major/%name-test
%_libdir/lib%name-test-%ver_major.so
%_pkgconfigdir/%name-test-%ver_major.pc

%files doc
%_datadir/gtk-doc/html/%name

%changelog
