%def_disable check

Name: ostree
Version: 2019.2
Release: alt1

Summary: Linux-based operating system develop/build/deploy tool
License: LGPLv2+
Group: Development/Other
Url: https://github.com/ostreedev/ostree

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/ostreedev/ostree/archive/v%version.tar.gz
Source: %name-%version.tar
# Note! Always use HEAD!!
# Source1-url: https://github.com/GNOME/libglnx/archive/master.zip
Source1: libglnx.tar
# Source2-url: https://github.com/mendsley/bsdiff/archive/master.zip
Source2: bsdiff.tar

Source44: import.info

Requires: libostree = %version-%release
Requires: %_bindir/gpg2

BuildRequires: db2latex-xsl libarchive-devel libe2fs-devel
BuildRequires: libfuse-devel libgpgme-devel liblzma-devel libsystemd-devel
BuildRequires: zlib-devel libselinux-devel libcurl-devel libssl-devel
BuildRequires: libgpgme-devel liblzma-devel libmount-devel
BuildRequires: gobject-introspection-devel
BuildRequires: libsoup-devel libattr-devel
BuildRequires: libavahi-glib-devel libgjs-devel
# For docs
BuildRequires: gtk-doc

%description
See https://ostree.readthedocs.io/en/latest/

%package -n libostree
Summary: Library files of %name
Group: Development/C
License: LGPLv2

%description -n libostree
Library files of %name.

%package -n libostree-devel
Summary: Library and header files of %name
Group: Development/C
License: LGPLv2
Requires: libostree = %version-%release

%description -n libostree-devel
Development package containing library and header files of %name.

%package -n libostree-devel-doc
Summary: Development documentation for lib%name
Group: Development/Documentation
BuildArch: noarch

%description -n libostree-devel-doc
This package contains development documentation for lib%name.

%prep
%setup -a1 -a2
%__subst 's|$(prefix)\(/lib/tmpfiles.d\)|\1|g' Makefile-boot.am

%build
NOCONFIGURE=1 sh -x ./autogen.sh

%configure --disable-silent-rules \
	   --without-dracut \
           --with-selinux \
           --with-curl \
           --with-openssl \
           --enable-gtk-doc \
	   --without-grub2-mkconfig-path

# hack to fix missed dirname declaration
echo "#include <libgen.h>" >>config.h

%make_build

%install
%makeinstall_std
rm -rf %buildroot/etc/dracut.conf.d/ %buildroot/usr/lib/dracut/
rm -rf %buildroot%_sysconfdir/grub.d/15_ostree
rm -rf %buildroot/lib/systemd/system-generators/ostree-system-generator

%check
%make check

%files
%doc COPYING README.md
#%_sysconfdir/grub.d/15_ostree
%_bindir/ostree
%_bindir/rofiles-fuse
%_libexecdir/lib%name/
%_libexecdir/%name/
%exclude /usr/lib/libostree/grub2-15_ostree
%_datadir/%name/
%_unitdir/ostree-prepare-root.service
%_unitdir/ostree-remount.service
%_tmpfilesdir/ostree-tmpfiles.conf
%_datadir/bash-completion/completions/ostree
%_unitdir/ostree-finalize-staged.service
%_unitdir/ostree-finalize-staged.path
%_typelibdir/*.typelib
%_man1dir/*
%_man5dir/ostree*

%files -n libostree
%_libdir/libostree*.so.*

%files -n libostree-devel
%_includedir/ostree-1/
%_libdir/libostree*.so
%_pkgconfigdir/*.pc
%_girdir/*.gir

%files -n libostree-devel-doc
%_datadir/gtk-doc/html/ostree/

%changelog
