%def_enable snapshot
%define _libexecdir %_prefix/libexec

%def_enable trust_module
%def_enable doc
# the hash implementation -- freebl or internal
%define hash_impl internal
%define trust_paths %_sysconfdir/pki/ca-trust/source:%_datadir/pki/ca-trust-source
%def_disable systemd

Name: p11-kit
Version: 0.23.15
Release: alt2

Summary: Utilities for PKCS#11 modules
Group: Security/Networking
License: BSD
Url: http://p11-glue.freedesktop.org/p11-kit.html

%if_enabled snapshot
# VCS: https://github.com/p11-glue/p11-kit.git
Source: %name-%version.tar
%else
#Source: http://p11-glue.freedesktop.org/releases/%name-%version.tar.gz
Source: https://github.com/p11-glue/%name/releases/download/%version/%name-%version.tar.gz
%endif

Source1: p11-kit-extract-trust
Patch: %name-%version-%release.patch
Patch1: lib%name-0.23.8-alt-lfs.patch

Requires: %_datadir/pki/ca-trust-source/ca-bundle.trust.p11-kit
Requires: %name-trust = %version-%release

BuildRequires(pre): rpm-macros-alternatives
BuildRequires: libtasn1-devel libffi-devel
%if %hash_impl == freebl
BuildRequires: libnss-devel
%endif
%{?_enable_systemd:BuildRequires: systemd-devel}
%{?_enable_doc:BuildRequires: gtk-doc}

%description
%name provides a way to load and enumerate PKCS#11 modules, as well
as a standard configuration setup for installing PKCS#11 modules in
such a way that they're discoverable.

This package contains the p11-kit tool for listing PKCS#11 modules.

%package -n lib%name
Summary: Library for loading and sharing PKCS#11 modules
Group: System/Libraries

%description -n lib%name
%name provides a way to load and enumerate PKCS#11 modules, as well
as a standard configuration setup for installing PKCS#11 modules in
such a way that they're discoverable.

%package trust
Summary: System trust module from %name package
Group: Security/Networking
Requires: lib%name = %version-%release
Provides: pkcs11-trust-module = %version-%release
Provides: lib%name-trust = %version-%release
Obsoletes: lib%name-trust < %version-%release
Requires: ca-trust

%description trust
The %name-trust package contains a system trust PKCS#11 module which
contains certificate anchors and black lists.

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
%name provides a way to load and enumerate PKCS#11 modules, as well
as a standard configuration setup for installing PKCS#11 modules in
such a way that they're discoverable.

The %name-devel package provides libraries and headers for developing
applications that use %name library.

%package  -n lib%name-devel-doc
Summary: Development documentation for %name
Group: Development/C
Conflicts: lib%name < %version-%release
BuildArch: noarch

%description -n lib%name-devel-doc
%name provides a way to load and enumerate PKCS#11 modules, as well
as a standard configuration setup for installing PKCS#11 modules in
such a way that they\'re discoverable.

This package contains development documentation for %name library.

%package server
Summary: Server and client commands for %name
Group: Security/Networking
Requires: lib%name = %version-%release

%description server
The %name-server package contains command line tools that enable to
export PKCS#11 modules through a Unix domain socket.  Note that this
feature is still experimental.

%package checkinstall
Summary: Check p11-kit-trust.so and libnssckbi.so compatibility
Group: Other
Requires: %name-trust
Requires: nss-utils

%description checkinstall
Check during install that p11-kit-trust.so and libnssckbi.so are
compatible with each other.
This package is intended to be used in the install check step in the build
system only and should not be installed in the real systems.

%prep
%setup -n %name-%version
%patch -p1
%{?_enable_snapshot:NOCONFIGURE=1 ./autogen.sh}
%patch1

%build
%autoreconf
%configure --disable-static \
	--enable-debug=no \
	%{subst_enable trust_module} \
%if_enabled trust_module
	--with-libtasn1 \
	--with-trust-paths=%trust_paths \
%endif
	--with-hash-impl=%hash_impl \
	%{subst_enable doc}
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_sysconfdir/pkcs11/modules
install -p -m755 %SOURCE1 %buildroot/%_libexecdir/%name/

# alternatives
mkdir -p %buildroot%_altdir
cat >%buildroot%_altdir/libnssckbi-%name <<EOF
%_libdir/libnssckbi.so	%_libdir/pkcs11/p11-kit-trust.so	30
EOF

%check
make check

%post checkinstall
TEST_DIR="$(mktemp -dt %name-installcheckXXXXXXXX)"
cd "$TEST_DIR"
mkdir nssdb
certutil -N --empty-password -d nssdb
ln -rs %_libdir/pkcs11/p11-kit-trust.so nssdb/libnssckbi.so
certutil -L -d nssdb -h 'Builtin Object Token' | sed -r -n \
	's|^Default Trust:(.+[^[:blank:]])[[:blank:]]+[^[:blank:]]+[[:blank:]]*$|\1|p' \
	| sort >certutil.list
trust list --filter=certificates \
	| sed -n -r 's|^[[:blank:]]+label:[[:blank:]]+(.+)[[:blank:]]*$|\1|p' \
	| sort >trust.list
if [ ! -s certutil.list ]; then
	echo "certutil.list is empty" 1>&2
	exit 1
fi
if [ ! -s trust.list ]; then
	echo "trust.list is empty" 1>&2
	exit 1
fi

diff trust.list certutil.list || exit 1
cd - >/dev/null
rm -r -- "$TEST_DIR"

%files
%_bindir/%name
%_libexecdir/%name/p11-kit-remote
%{?_enable_doc:%_man8dir/p11-kit.*}

%if_enabled systemd
%_prefix/lib/systemd/user/%name-remote.socket
%_prefix/lib/systemd/user/%name-remote@.service
%_prefix/lib/systemd/user/sockets.target.wants/%name-remote.socket
%endif

%files -n lib%name
%doc %name/pkcs11.conf.example
%doc AUTHORS COPYING NEWS README
%_libdir/lib%name.so.*
%_libdir/%name-proxy.so
%dir %_libdir/pkcs11/
%dir %_libexecdir/%name
%dir %_datadir/%name
%dir %_datadir/%name/modules
%dir %_sysconfdir/pkcs11
%dir %_sysconfdir/pkcs11/modules
%{?_enable_doc:%_man5dir/pkcs11.conf.*}

%exclude %_sysconfdir/pkcs11/pkcs11.conf.example
%exclude %_libdir/pkcs11/*.la

%files -n lib%name-devel
%_includedir/%name-1
%_libdir/lib%name.so
%_pkgconfigdir/%name-1.pc

%if_enabled doc
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/%name
%endif

%if_enabled trust_module
%files trust
%_bindir/trust
%_libdir/pkcs11/%name-trust.so
%_datadir/%name/modules/%name-trust.module
%_libexecdir/%name/%name-extract-trust
%_libexecdir/%name/trust-extract-compat
%{?_enable_doc:%_man1dir/trust.*}
%_altdir/libnssckbi-%name
%endif

%files server
%_libdir/pkcs11/%name-client.so
%_libexecdir/%name/%name-server

%files checkinstall
%changelog
