# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-DateTime-Format-DBI
Version:        0.041
Release:        alt1_12
Summary:        Find a parser class for a database connection
License:        GPL+ or Artistic 
Group:          Development/Other
URL:            https://metacpan.org/release/DateTime-Format-DBI
Source0:        https://cpan.metacpan.org/authors/id/C/CF/CFAERBER/DateTime-Format-DBI-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  %{_bindir}/iconv
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(DateTime.pm)
BuildRequires:  perl(DateTime/Format/SQLite.pm)
BuildRequires:  perl(DBD/SQLite.pm)
BuildRequires:  perl(DBI.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/NoWarnings.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)
# require the dbd-specific datetime formats, so this "just works" the way we
# expect it to.
Requires:       perl(DateTime/Format/MySQL.pm)
Requires:       perl(DateTime/Format/Pg.pm)
Requires:       perl(DateTime/Format/DB2.pm)
Source44: import.info

%description
This module finds a DateTime::Format::* class that is suitable for the use
with a given DBI connection (and DBD::* driver).

Note that this is most useful if you actually have the DateTime::Format::*
class for your particular database(s) installed!  See, e.g.,
perl-DateTime-MySQL, perl-DateTime-Oracle, perl-DateTime-DB2, etc.

%prep
%setup -q -n DateTime-Format-DBI-%{version}
iconv -f ISO-8859-1 -t UTF-8 LICENSE > LICENSE.utf && \
touch -r LICENSE LICENSE.utf && \
mv -f LICENSE.utf LICENSE

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} +
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes LICENSE README
%{perl_vendor_privlib}/*

%changelog
