# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
%define fedora 28
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	Typical installation tasks for system administrators
Name:		perl-Sysadm-Install
Version:	0.48
Release:	alt1_6
License:	GPL+ or Artistic
Group:		Development/Other
URL:		https://metacpan.org/release/Sysadm-Install
Source0:	https://cpan.metacpan.org/authors/id/M/MS/MSCHILLI/Sysadm-Install-%{version}.tar.gz
BuildArch:	noarch
# Module Build
BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:	perl-devel
%if 0%{?fedora} > 20 || 0%{?rhel} > 7
BuildRequires:	rpm-build-perl
%endif
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
# Module Runtime
BuildRequires:	perl(Archive/Tar.pm)
BuildRequires:	perl(Cwd.pm)
BuildRequires:	perl(Encode.pm)
BuildRequires:	perl(Expect.pm)
BuildRequires:	perl(File/Basename.pm)
BuildRequires:	perl(File/Copy.pm)
BuildRequires:	perl(File/Path.pm)
BuildRequires:	perl(File/Spec/Functions.pm)
BuildRequires:	perl(File/Temp.pm)
BuildRequires:	perl(File/Which.pm)
BuildRequires:	perl(HTTP/Request.pm)
BuildRequires:	perl(HTTP/Status.pm)
BuildRequires:	perl(Log/Log4perl.pm)
BuildRequires:	perl(Log/Log4perl/Util.pm)
BuildRequires:	perl(LWP/UserAgent.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(Term/ReadKey.pm)
BuildRequires:	perl(warnings.pm)
# Test Suite
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(File/Spec.pm)
BuildRequires:	perl(Test/More.pm)
BuildRequires:	perl(utf8.pm)
# Runtime
Requires:	perl(Archive/Tar.pm)
Requires:	perl(Encode.pm)
Requires:	perl(Expect.pm)
Requires:	perl(HTTP/Request.pm)
Requires:	perl(HTTP/Status.pm)
Requires:	perl(LWP/UserAgent.pm)
Source44: import.info

%description
"Sysadm::Install" executes shell-like commands performing typical
installation tasks: Copying files, extracting tarballs, calling "make".
It has a "fail once and die" policy, meticulously checking the result of
every operation and calling "die()" immediately if anything fails,
with optional logging of everything.

"Sysadm::Install" also supports a *dry_run* mode, in which it logs
everything, but suppresses any write actions.

%prep
%setup -q -n Sysadm-Install-%{version}

# Fix perl interpreter in eg/mkperl
perl -pi -e 's|/usr/local/bin/perl|/usr/bin/perl|;' eg/mkperl

# Note: not turning off exec bits in examples because they don't
# introduce any unwanted dependencies

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
make test TEST_VERBOSE=1

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} -c %{buildroot}

%files
%doc Changes README eg/
# one-liner is an overly-generic name to include in %%{_bindir} and is included
# as %%doc if needed
%exclude %{_bindir}/one-liner
%{perl_vendor_privlib}/Sysadm/

%changelog
