# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
%define fedora 28
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Run optional test
%if ! (0%{?rhel})
%bcond_without perl_Test_Warnings_enables_optional_test
%else
%bcond_with perl_Test_Warnings_enables_optional_test
%endif

Name:		perl-Test-Warnings
Version:	0.026
Release:	alt1_8
Summary:	Test for warnings and the lack of them
License:	GPL+ or Artistic
Group:		Development/Other
URL:		https://metacpan.org/release/Test-Warnings
Source0:	https://cpan.metacpan.org/authors/id/E/ET/ETHER/Test-Warnings-%{version}.tar.gz
BuildArch:	noarch
# Build
BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:	perl-devel
BuildRequires:	rpm-build-perl
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
# Module
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(Exporter.pm)
BuildRequires:	perl(Test/Builder.pm)
BuildRequires:	perl(parent.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(warnings.pm)
# Test Suite
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
BuildRequires:	perl(File/Spec.pm)
BuildRequires:	perl(if.pm)
BuildRequires:	perl(lib.pm)
BuildRequires:	perl(Test/More.pm)
BuildRequires:	perl(Test/Tester.pm)
%if %{with perl_Test_Warnings_enables_optional_test}
# Optional Tests
BuildRequires:	perl(CPAN/Meta.pm)
%if 0%{?fedora} || 0%{?rhel} > 7
BuildRequires:	perl(CPAN/Meta/Check.pm)
%endif
BuildRequires:	perl(CPAN/Meta/Prereqs.pm)
BuildRequires:	perl(CPAN/Meta/Requirements.pm)
BuildRequires:	perl(PadWalker.pm)
%endif
# Runtime
Requires:	perl(Carp.pm)
Source44: import.info

%description
If you've ever tried to use Test::NoWarnings to confirm there are no warnings
generated by your tests, combined with the convenience of done_testing to not
have to declare a test count, you'll have discovered that these two features do
not play well together, as the test count will be calculated before the
warnings test is run, resulting in a TAP error (see examples/test_nowarnings.pl
in this distribution for a demonstration).

This module is intended to be used as a drop-in replacement for
Test::NoWarnings: it also adds an extra test, but runs this test before
done_testing calculates the test count, rather than after. It does this by
hooking into done_testing as well as via an END block. You can declare a plan,
or not, and things will still Just Work.

It is actually equivalent to:

    use Test::NoWarnings 1.04 ':early';

as warnings are still printed normally as they occur. You are safe, and
enthusiastically encouraged, to perform a global search-replace of the above
with use Test::Warnings; whether or not your tests have a plan.

%prep
%setup -q -n Test-Warnings-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} ';'
# %{_fixperms} %{buildroot}

%check
make test

%files
%doc --no-dereference LICENCE
%doc Changes CONTRIBUTING README examples/
%{perl_vendor_privlib}/Test/

%changelog
