%define	php7_extension	sodium
Name:	 	php7-%php7_extension
Version:	%php7_version
Release:	%php7_release

Summary:	Sodium library support for PHP
Group:		System/Servers
License:	PHP-3.01

Source1:	php7-%php7_extension.ini
Source2:	php7-%php7_extension-params.sh

BuildRequires(pre): rpm-build-php7
BuildRequires: libsodium-devel
BuildRequires:	php7-devel = %php7_version

%description
The %name includes a dynamic shared object (DSO) that adds
sodium support to PHP.

Sodium is a new, easy-to-use software library for encryption, decryption,
signatures, password hashing and more.

It is a portable, cross-compilable, installable, packageable fork of NaCl, with
a compatible API, and an extended API to improve usability even further.

Its goal is to provide all of the core operations needed to build higher-level
cryptographic tools.

%prep
%setup -T -c
cp -pr %php7_extsrcdir/%php7_extension/* .

%build
phpize

%configure \
	--with-libdir=%_lib \
	--with-%php7_extension
%php7_make

%install
%php7_make_install
install -D -m 644 %SOURCE1 %buildroot/%php7_extconf/%php7_extension/config
install -D -m 644 %SOURCE2 %buildroot/%php7_extconf/%php7_extension/params

%check
NO_INTERACTION=1 make test

%post
%php7_extension_postin

%preun
%php7_extension_preun

%files
%php7_extconf/%php7_extension
%php7_extdir/*
%doc CREDITS
%changelog
