%define postgrey_user postgrey
%define postgrey_group postgrey
%define postgrey_home %_localstatedir/%name

Name: postgrey
Version: 1.37
Release: alt1

Summary: Greylisting Policy Server for Postfix and Exim
License: GPL
Group: System/Servers

URL: http://postgrey.schweikert.ch
# Download from http://postgrey.schweikert.ch/pub/
BuildArch: noarch
Source0: %name-%version.tar
Source1: %name.init
Source2: %name.sysconfig
Source3: %{name}_clients_dump
Source6: %name.README.ALT

BuildPreReq: perl perl-base perl-IO-Multiplex perl-Net-Server perl-BerkeleyDB perl-Net-DNS
BuildRequires: perl-NetAddr-IP
BuildRequires: perl-podlators
Requires: perl-IO-Multiplex

%description
Postgrey is a Postfix policy server implementing greylisting.
When a request for delivery of a mail is received by Postfix 
via SMTP, the triplet CLIENT_IP / SENDER / RECIPIENT is built. 
If it is the first time that this triplet is seen, or if the 
triplet was first seen less than 5 minutes, then the mail gets 
rejected with a temporary error. Hopefully spammers or viruses 
will not try again later, as it is however required per RFC.
Edit your configuration files:
/etc/postfix/main.cf:
  smtpd_recipient_restrictions = ...
    check_policy_service unix:postgrey/socket, ...
or if you like to use inet sockets (modify the IP if needed):
/etc/sysconfig/postgrey:
  OPTIONS="--inet=127.0.0.1:60000"
/etc/postfix/main.cf:
  smtpd_recipient_restrictions = ...
    check_policy_service inet:127.0.0.1:60000, ...

%prep
%setup

%install
# directories
install -d -m1711 %buildroot%_localstatedir/%name
install -d -m1755 %buildroot%_var/run/%name

# binaries
install -pD -m0755 %name %buildroot%_sbindir/%name
install -pD -m0755 contrib/postgreyreport %buildroot%_sbindir/postgreyreport
install -m0755 %SOURCE3 %buildroot%_sbindir/%{name}_clients_dump

# initscript and sysconfig-file
install -pD -m0755 %SOURCE1 %buildroot%_initdir/%name
install -pD -m0644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/%name

# whitelists
install -pD -m0644 postgrey_whitelist_clients %buildroot%_sysconfdir/%name/whitelist_clients
install -pD -m0644 postgrey_whitelist_recipients %buildroot%_sysconfdir/%name/whitelist_recipients
touch %buildroot%_sysconfdir/%name/whitelist_clients.local

# README.ALT
install -pD -m0644 %SOURCE6 README.ALT

# manpages
pod2man %name >%name.1
install -pD -m0644 %name.1 %buildroot%_man1dir/%name.1
pod2man contrib/postgreyreport > postgreyreport.1
install -pD -m0644 postgreyreport.1  %buildroot%_man1dir/postgreyreport.1

%pre
/usr/sbin/groupadd -r -f %postgrey_group ||:
/usr/sbin/useradd -g %postgrey_group -c 'The Postgrey Daemon' \
        -d %postgrey_home -s /dev/null -r %postgrey_user >/dev/null 2>&1 ||:

%post
%post_service %name

%preun
%preun_service %name

%files
%_sbindir/*
%_initdir/%name
%config(noreplace) %_sysconfdir/sysconfig/*
%config(noreplace) %_sysconfdir/%name/*
%dir %attr(1771,root,%postgrey_group) %_localstatedir/%name
%dir %attr(1775,root,%postgrey_group) %_var/run/%name
%_man1dir/*
%doc README* Changes

%changelog
