%define _unpackaged_files_terminate_build 1

%define oname ptpython

Name: %oname
Version: 0.41
Release: alt2
Summary: Python REPL build on top of prompt_toolkit
License: BSD
Group: Development/Python
BuildArch: noarch
Url: https://pypi.org/project/ptpython/

# https://github.com/jonathanslenders/ptpython.git
Source: %name-%version.tar

Patch1: %name-%version-alt.patch

BuildRequires: python-devel python-module-setuptools ipython
BuildRequires: python-module-prompt_toolkit python-module-jedi
BuildRequires: python-module-docopt

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools ipython3
BuildRequires: python3-module-prompt_toolkit python3-module-jedi
BuildRequires: python3-module-docopt

%py_requires  IPython jedi
%add_python_req_skip asyncio asyncssh

%description
ptpython is an advanced Python REPL built on top of the prompt_toolkit
library.

%package -n %{oname}3
Summary: Python REPL build on top of prompt_toolkit
Group: Development/Python3
%py3_requires IPython jedi

%description -n %{oname}3
ptpython is an advanced Python REPL built on top of the prompt_toolkit
library.

%prep
%setup
%patch1 -p1

cp -fR . ../python3

%build
%python_build_debug

pushd ../python3
%python3_build_debug
popd

%install
pushd ../python3
%python3_install
popd

%python_install

%check
PYTHONPATH=%buildroot%python_sitelibdir python tests/run_tests.py -v

pushd ../python3
PYTHONPATH=%buildroot%python3_sitelibdir python3 tests/run_tests.py -v
popd

%files
%doc CHANGELOG *.rst
%_bindir/*
%exclude %_bindir/*3
%python_sitelibdir/*

%files -n %{oname}3
%doc CHANGELOG *.rst
%_bindir/*3
%python3_sitelibdir/*

%changelog
