Name: pyside-qt4
Version: 1.2.2
Release: alt3.git20140501
Summary: Python bindings for the Qt cross-platform application and UI framework
License: LGPLv2.1
Group: Development/Tools
Url: http://www.pyside.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar

BuildPreReq: python-devel libqt4-devel gcc-c++ cmake
BuildPreReq: python-module-sphinx-devel shiboken libshiboken-devel
BuildPreReq: libgeneratorrunner-devel graphviz xvfb-run
BuildPreReq: generatorrunner phonon-devel qt4-designer xml-utils
BuildPreReq: xsltproc libxml2-devel libxslt-devel
BuildPreReq: libqt4-assistant-devel

%description
The PySide project provides LGPL-licensed Python bindings for the Qt
cross-platform application and UI framework, as well as a complete
toolchain for rapidly generating bindings for any Qt-based C++ class
hierarchies. PySide Qt bindings allow both free open source and
proprietary software development and ultimately aim to support all of
the platforms as Qt itself.

%package -n lib%name
Summary: Shared libraries of PySide
Group: System/Libraries

%description -n lib%name
The PySide project provides LGPL-licensed Python bindings for the Qt
cross-platform application and UI framework, as well as a complete
toolchain for rapidly generating bindings for any Qt-based C++ class
hierarchies. PySide Qt bindings allow both free open source and
proprietary software development and ultimately aim to support all of
the platforms as Qt itself.

This package contains shared libraries of PySide.

%package -n lib%name-devel
Summary: Development files of PySide
Group: Development/C++
Requires: lib%name = %version-%release

%description -n lib%name-devel
The PySide project provides LGPL-licensed Python bindings for the Qt
cross-platform application and UI framework, as well as a complete
toolchain for rapidly generating bindings for any Qt-based C++ class
hierarchies. PySide Qt bindings allow both free open source and
proprietary software development and ultimately aim to support all of
the platforms as Qt itself.

This package contains development files of PySide.

%package -n lib%name-devel-doc
Summary: Documentation for PySide
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
The PySide project provides LGPL-licensed Python bindings for the Qt
cross-platform application and UI framework, as well as a complete
toolchain for rapidly generating bindings for any Qt-based C++ class
hierarchies. PySide Qt bindings allow both free open source and
proprietary software development and ultimately aim to support all of
the platforms as Qt itself.

This package contains development documentation for PySide.

%package -n python-module-PySide
Summary: Python module of PySide
Group: Development/Python

%description -n python-module-PySide
The PySide project provides LGPL-licensed Python bindings for the Qt
cross-platform application and UI framework, as well as a complete
toolchain for rapidly generating bindings for any Qt-based C++ class
hierarchies. PySide Qt bindings allow both free open source and
proprietary software development and ultimately aim to support all of
the platforms as Qt itself.

This package contains python module of PySide.

%prep
%setup

%prepare_sphinx .
ln -s ../objects.inv doc

%build
export PATH=$PATH:%_qt4dir/bin
%add_optflags -I%_includedir/shiboken
cmake \
	-DCMAKE_INSTALL_PREFIX:PATH=%prefix \
%if "%_lib" == "lib64"
	-DLIB_SUFFIX:STRING=64 \
%endif
	-DCMAKE_STRIP:FILEPATH="/bin/echo" \
	-DENABLE_GCC_OPTIMIZATION:BOOL=ON \
	-DENABLE_VERSION_SUFFIX:BOOL=OFF \
	-DQT_SRC_DIR:PATH=%_datadir/graphviz \
	-DUSE_XVFB:BOOL=ON \
	-DCMAKE_C_FLAGS:STRING="%optflags" \
	-DCMAKE_CXX_FLAGS:STRING="%optflags" \
	-DQT_PHONON_INCLUDE_DIR:PATH="%_includedir/kde4" \
	.

%make_build VERBOSE=1

%install
%makeinstall_std

pushd doc
export PATH=$PATH:%_qt4dir/bin
cmake -DCMAKE_INSTALL_PREFIX:PATH=%buildroot%prefix .
%make apidocinstall
mv %buildroot%_docdir/PySide- %buildroot%_docdir/PySide
popd

%files -n lib%name
%doc COPYING
%_libdir/*.so.*
%_datadir/PySide*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_libdir/cmake/*
%_pkgconfigdir/*

%files -n lib%name-devel-doc
%_docdir/PySide

%files -n python-module-PySide
%python_sitelibdir/*

%changelog
