%define _name apsw
%define rel r1
%define sqlite_ver 3.29.0
%def_with python2

Name: python-module-%_name
Version: 3.29.0
Release: alt1.%rel

Summary: Another Python SQLite Wrapper
License: zlib/libpng License
Group: Development/Python
Url: http://rogerbinns.github.io/apsw

Source: https://github.com/rogerbinns/apsw/releases/download/%version-%rel/%_name-%version-%rel.zip

BuildRequires: libsqlite3-devel >= %sqlite_ver unzip
BuildRequires: python3-devel rpm-build-python3
%if_with python2
BuildRequires: python-devel
%endif

%description
APSW is a Python wrapper for the SQLite embedded relational database
engine. In contrast to other wrappers such as pysqlite it focuses on
being a minimal layer over SQLite attempting just to translate the
complete SQLite API into Python.

%package -n python3-module-%_name
Summary: Another Python SQLite Wrapper Python 3 packages
Group: Development/Python3

%description -n python3-module-%_name
APSW is a Python 3 wrapper for the SQLite embedded relational database
engine. In contrast to other wrappers such as pysqlite it focuses on
being a minimal layer over SQLite attempting just to translate the
complete SQLite API into Python 3.

%prep
%setup -n %_name-%version-%rel

%if_with python2
rm -rf ../python2
cp -a . ../python2
find ../python2 -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python}|'
%endif

find . -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python3}|'

%build
%python3_build

%if_with python2
pushd ../python2
%python_build
popd
%endif

%install
%python3_install

%if_with python2
pushd ../python2
%python_install
popd
%endif

%files
%if_with python2
%python_sitelibdir/*
%doc doc/*
%endif

%files -n python3-module-%_name
%python3_sitelibdir/*
%doc doc/*


%changelog
