%define oname babel

%def_with doc
#def_disable check

Name:    python-module-%oname
Version: 2.6.0
Release: alt1
Epoch:   1

Summary: a collection of tools for internationalizing Python applications
License: BSD
Group: Development/Python

Url: http://babel.pocoo.org/

# https://github.com/mitsuhiko/babel.git
Source: %name-%version.tar
Source1: CLDR.tar

BuildArch: noarch
BuildRequires: python-module-setuptools python-module-sphinx-devel
BuildRequires: python-module-pytest-cov python-module-freezegun
%{?!_without_check:%{?!_disable_check:BuildRequires: %py_dependencies setuptools.command.test pytz}}

%setup_python_module babel

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-pytz
BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python3-module-pytest-cov python3-module-freezegun
%py_requires pytz

%description
Babel is an integrated collection of utilities that assist in
internationalizing and localizing Python applications, with an emphasis
on web-based applications.
The functionality Babel provides for internationalization (I18n) and
localization (L10N) can be separated into two different aspects:
  * tools to build and work with gettext message catalogs, and
  * a Python interface to the CLDR (Common Locale Data Repository),
    providing access to various locale display names, localized number
    and date formatting, etc.

%package -n python3-module-%oname
Summary: a collection of tools for internationalizing Python 3 applications
Group: Development/Python3
%py3_requires pytz

%description -n python3-module-%oname
Babel is an integrated collection of utilities that assist in
internationalizing and localizing Python applications, with an emphasis
on web-based applications.
The functionality Babel provides for internationalization (I18n) and
localization (L10N) can be separated into two different aspects:
  * tools to build and work with gettext message catalogs, and
  * a Python interface to the CLDR (Common Locale Data Repository),
    providing access to various locale display names, localized number
    and date formatting, etc.

%prep
%setup -a1
rm -rf ../python3
cp -a . ../python3

%if_with doc
%prepare_sphinx .
ln -s ../objects.inv docs/
%endif

%build
python scripts/import_cldr.py CLDR/common
%python_build
pushd ../python3
python scripts/import_cldr.py CLDR/common
%python3_build
popd

%install
%python_install
mv %buildroot%_bindir/pybabel %buildroot%_bindir/pybabel.py2

pushd ../python3
%python3_install
popd

%if_with doc
%make -C docs html
%endif

%check
python setup.py test
pushd ../python3
python3 setup.py test
popd

%files
%_bindir/pybabel.py2
%python_sitelibdir/*
%doc AUTHORS CHANGES README.rst
%if_with doc
%doc docs/_build/html
%endif

%files -n python3-module-%oname
%doc AUTHORS CHANGES README.rst
%if_with doc
%doc docs/_build/html
%endif
%_bindir/pybabel
%python3_sitelibdir/*

%changelog
