%define modname beaker

Name: python-module-%modname
Version: 1.10.1
Release: alt1

Summary: A Session and Caching library with WSGI Middleware

License: BSD-3-Clause
Group: Development/Python
Url: https://github.com/bbangert/beaker

Source: %name-%version.tar

BuildRequires: python-module-setuptools
BuildRequires: fdupes

Requires: python-module-pylibmc
Requires: python-module-memcached >= 1.58
Requires: python-module-funcsigs

BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel
BuildPreReq: python3-module-setuptools

BuildArch: noarch

%add_python_req_skip jarray javax

%description
Beaker is a web session and general caching library that includes WSGI
middleware for use in web applications. As a general caching library, Beaker can
handle storing for various times any Python object that can be pickled with
optional back-ends on a fine-grained basis. Beaker was built largely on the code
from MyghtyUtils, then refactored and extended with database support.

%package -n python3-module-%modname
Summary: A Session and Caching library with WSGI Middleware
Group: Development/Python3
%add_python3_req_skip jarray javax
%add_python3_req_skip javax.crypto javax.crypto.spec

%description -n python3-module-%modname
Beaker is a web session and general caching library that includes WSGI
middleware for use in web applications. As a general caching library, Beaker
can handle storing for various times any Python object that can be pickled with
optional back-ends on a fine-grained basis. Beaker was built largely on the code
from MyghtyUtils, then refactored and extended with database support.

%prep
%setup

cp -fR . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
%python_install

pushd ../python3
%python3_install
popd

%files
%doc README.rst
%python_sitelibdir/*

%files -n python3-module-%modname
%doc README.rst
%python3_sitelibdir/*


%changelog
