%define oname botocore

%def_with python3

Name: python-module-%oname
Version: 1.6.0
Release: alt1.1
Summary: The low-level, core functionality of boto 3
License: ASLv2.0
Group: Development/Python
Url: https://pypi.python.org/pypi/botocore/

# https://github.com/boto/botocore.git
Source: %name-%version.tar
Patch1: %oname-%version-alt-docsetup.patch
Patch2: %oname-%version-alt-reqs.patch
BuildArch: noarch

BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python-module-alabaster python-module-dateutil python-module-guzzle_sphinx_theme python-module-html5lib python-module-jmespath
BuildRequires: python-module-nose python-module-objects.inv python-module-pbr python-module-setuptools python-module-tox python-module-unittest2
BuildRequires: python-module-requests python-module-six python-module-urllib3 python-module-mock python-module-docutils python-module-jmespath
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-dateutil python3-module-html5lib python3-module-nose python3-module-pbr python3-module-setuptools
BuildRequires: python3-module-tox python3-module-unittest2
BuildRequires: python3-module-requests python3-module-six python3-module-urllib3 python3-module-mock python3-module-docutils python3-module-jmespath
%endif

%py_provides %oname

%description
A low-level interface to a growing number of Amazon Web Services. The
botocore package is the foundation for AWS-CLI.

WARNING
Botocore is currently under a developer preview, and its API is subject
to change prior to a GA (1.0) release. Until botocore reaches a 1.0
release, backwards compatibility is not guaranteed.

If you need a stable interface, please consider using boto.

%package -n python3-module-%oname
Summary: The low-level, core functionality of boto 3
Group: Development/Python3
%py3_provides %oname

%description -n python3-module-%oname
A low-level interface to a growing number of Amazon Web Services. The
botocore package is the foundation for AWS-CLI.

WARNING
Botocore is currently under a developer preview, and its API is subject
to change prior to a GA (1.0) release. Until botocore reaches a 1.0
release, backwards compatibility is not guaranteed.

If you need a stable interface, please consider using boto.

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
A low-level interface to a growing number of Amazon Web Services. The
botocore package is the foundation for AWS-CLI.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
A low-level interface to a growing number of Amazon Web Services. The
botocore package is the foundation for AWS-CLI.

This package contains documentation for %oname.

%prep
%setup
%patch1 -p1
%patch2 -p1

%if_with python3
cp -fR . ../python3
%endif

%prepare_sphinx docs
ln -s ../objects.inv docs/source/

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

export PYTHONPATH=$PWD
%make -C docs pickle
%make -C docs html

cp -fR docs/build/pickle %buildroot%python_sitelibdir/%oname/

%check
py.test ||:
%if_with python3
pushd ../python3
py.test3 ||:
popd
%endif

%files
%doc *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/*/pickle

%files pickles
%python_sitelibdir/*/pickle

%files docs
%doc docs/build/html/*

%if_with python3
%files -n python3-module-%oname
%doc *.rst
%python3_sitelibdir/*
%endif

%changelog
