%define oname bugzilla


Name: python-module-%oname
Version: 2.1.0
Release: alt1

Summary: A python library.. for bugzilla!

License: GPLv2.0
Group: Development/Python
Url: https://fedorahosted.org/python-bugzilla/

BuildArch: noarch

# Source-url: https://fedorahosted.org/releases/p/y/python-bugzilla/python-bugzilla-0.9.0.tar.gz
Source: bugzilla-%version.tar

# Automatically added by buildreq on Wed Jan 13 2010
BuildRequires(pre): rpm-build-python
BuildRequires: python-devel
BuildRequires: python-module-PyXML
BuildRequires: python-module-Reportlab
BuildRequires: python-modules-email
BuildRequires: python-module-requests

BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel
BuildPreReq: python3-module-requests
BuildPreReq: python3-module-setuptools


%description
This is a python module that provides a nice, python-ish interface to Bugzilla
over XMLRPC.

It was originally written specifically for Red Hat's Bugzilla instance, but
now supports the Web Services provided by upstream Bugzilla 3.0 and 3.2 also.

It also includes a 'bugzilla' commandline client which can be used for quick,
ad-hoc bugzilla jiggery-pokery.

%package -n python3-module-%oname
Summary: A python library.. for bugzilla!
Group: Development/Python3

%description -n python3-module-%oname
This is a python module that provides a nice, python-ish interface to Bugzilla
over XMLRPC.

It was originally written specifically for Red Hat's Bugzilla instance, but
now supports the Web Services provided by upstream Bugzilla 3.0 and 3.2 also.

It also includes a 'bugzilla' commandline client which can be used for quick,
ad-hoc bugzilla jiggery-pokery.

%prep
%setup -n bugzilla-%version

rm -rf ../python3
cp -fR . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
pushd ../python3
%python3_install
popd
pushd %buildroot/%_bindir
mv %oname %oname.py3
popd
%python_install

%files
%doc COPYING *.md examples/*
%_bindir/%oname
%_man1dir/bugzilla.*
%python_sitelibdir/bugzilla/
%python_sitelibdir/python_bugzilla*.egg-info

%files -n python3-module-%oname
%doc COPYING *.md examples/*
%_bindir/%oname.py3
%_man1dir/bugzilla.*
%python3_sitelibdir/bugzilla/
%python3_sitelibdir/python_bugzilla*.egg-info


%changelog
