%define _unpackaged_files_terminate_build 1

%define oname celery

%add_python3_req_skip celery.utils.nodenames
%add_python3_req_skip celery.utils.time
%add_python3_req_skip kombu.utils.objects

%def_with python3
%def_enable check

Name: python-module-%oname
Version: 4.2.1
Release: alt1
Group: Development/Python
License: BSD License
Summary: Celery is an open source asynchronous task queue/job queue based on distributed message passing
URL: https://github.com/celery/celery

# https://github.com/celery/celery.git
Source: %name-%version.tar

Patch1: %oname-%version-alt-tests.patch

# Patches from Debian
Patch10: 0005-Disable-pytest-3.3-log-capturing-to-avoid-changing-l.patch
Patch11: 0007-Set-shell-in-su-invocation.patch
Patch12: privacy.patch

BuildRequires: dvipng
# /proc is required for some tests
BuildRequires: /proc
BuildRequires: python-module-setuptools
BuildRequires: python-module-mock
BuildRequires: python-module-alabaster python-module-billiard python-module-kombu python-module-objects.inv python2.7(sphinx_celery)
BuildRequires: python-module-html5lib python-module-nose python-module-pbr
BuildRequires: python-module-sphinxcontrib-issuetracker python-module-unittest2
BuildRequires: python2.7(case) python2.7(eventlet)
BuildRequires: python2.7(redis)
BuildRequires(pre): rpm-macros-sphinx
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pytest
BuildRequires: python3-module-html5lib python3-module-nose python3-module-pbr
BuildRequires: python3-module-pycrypto
BuildRequires: python3-module-django python3-module-ecdsa python3-module-pytz python3-module-unittest2 python3(requests)
BuildRequires: python3(case) python3(eventlet) python3(kombu) python3(billiard)
BuildRequires: python3(redis)
%endif

%description
Celery is an open source asynchronous task queue/job queue based on
distributed message passing.  It is focused on real-time operation,
but supports scheduling as well.

The execution units, called tasks, are executed concurrently on one or
more worker nodes using multiprocessing, `Eventlet`_ or `gevent`_.  Tasks can
execute asynchronously (in the background) or synchronously
(wait until ready).

Celery is used in production systems to process millions of tasks a day.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Celery is an open source asynchronous task queue/job queue based on
distributed message passing.  It is focused on real-time operation,
but supports scheduling as well.

The execution units, called tasks, are executed concurrently on one or
more worker nodes using multiprocessing, `Eventlet`_ or `gevent`_.  Tasks can
execute asynchronously (in the background) or synchronously
(wait until ready).

Celery is used in production systems to process millions of tasks a day.

This package contains documentation for %oname.

%if_with python3
%package -n python3-module-%oname
Summary: Celery is an open source asynchronous task queue/job queue based on distributed message passing
Group: Development/Python3

%description -n python3-module-%oname
Celery is an open source asynchronous task queue/job queue based on
distributed message passing.  It is focused on real-time operation,
but supports scheduling as well.

The execution units, called tasks, are executed concurrently on one or
more worker nodes using multiprocessing, `Eventlet`_ or `gevent`_.  Tasks can
execute asynchronously (in the background) or synchronously
(wait until ready).

Celery is used in production systems to process millions of tasks a day.
%endif

%prep
%setup
%patch1 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1

%if_with python3
cp -fR . ../python3
%endif

%prepare_sphinx .
ln -s ../objects.inv docs/

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done
popd
%endif

%python_install

%if "%_target_libdir_noarch" != "%_libdir"
mv %buildroot%_target_libdir_noarch %buildroot%_libdir
%endif

export PYTHONPATH=%buildroot%python_sitelibdir
%make -C docs html

%check
rm -f t/unit/contrib/test_sphinx.py
python setup.py test

%if_with python3
pushd ../python3
rm -f t/unit/contrib/test_sphinx.py
python3 setup.py test
popd
%endif

%files
%doc Changelog *.txt *.rst TODO
%_bindir/*
%if_with python3
%exclude %_bindir/*.py3
%endif
%python_sitelibdir/celery*

%files docs
%doc docs/_build/html/*

%if_with python3
%files -n python3-module-%oname
%doc Changelog *.txt *.rst TODO
%_bindir/*.py3
%python3_sitelibdir/celery*
%endif

%changelog
