%define oldname python-cliapp
%global pkgname cliapp

Name: python-module-cliapp
Version: 1.20160724
Release: alt1

Summary: Python framework for Unix command line programs

Group: Other
License: GPLv2+
Url: http://liw.fi/%pkgname

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: http://code.liw.fi/debian/pool/main/p/%oldname/%{oldname}_%version.orig.tar.xz
Source: %name-%version.tar
Source44: import.info

BuildRequires(pre): rpm-build-python
BuildRequires: python-devel

BuildArch: noarch
BuildRequires: python-module-coverage-test-runner
BuildRequires: python-module-sphinx
BuildRequires: python-module-yaml

%description
cliapp is a Python framework for Unix-like command line programs. It
contains the typical stuff such programs need to do, such as parsing
the command line for options, and iterating over input files.

%package doc
Group: Other
Summary: Documentation for %pkgname

%description doc
This package contains the documentation for %pkgname, a Python
framework for Unix command line programs.

%prep
%setup

%build
%python_build
# Build documentation
%make_build

%install
%python_install

%check
# CoverageTestRunner trips up on build directory;
# since we've already done the install phase, remove it first
rm -rf build

# rm: cannot remove '.coverage': No such file or directory
#make check
python -m CoverageTestRunner --ignore-missing-from=without-tests

%files
%doc COPYING NEWS README
%_man5dir/cliapp.5*
%python_sitelibdir_noarch/%pkgname
%python_sitelibdir_noarch/%pkgname-%version-py?.?.egg-info

%files -n python-module-cliapp-doc
%doc doc/_build/html/*

%changelog
