%define _unpackaged_files_terminate_build 1

%define modulename icu

%def_with python3

Name: python-module-%modulename
Version: 2.3.1
Release: alt1

%setup_python_module %modulename

Summary: Python extension wrapping the ICU C++ API
License: ISC-style
Group: Development/Python

Url: http://pyicu.osafoundation.org/

%define srcname PyICU-%version
# http://pypi.python.org/packages/source/P/PyICU/%srcname.tar.gz
# VCS: https://github.com/ovalhub/pyicu.git
Source: %name-%version.tar

BuildRequires: gcc-c++ libicu-devel python-devel
BuildRequires: python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
%endif

%description
PyICU - Python extension wrapping the ICU C++ API.

%if_with python3
%package -n python3-module-%modulename
Summary: Python extension wrapping the ICU C++ API
Group: Development/Python3

%description -n python3-module-%modulename
PyICU - Python extension wrapping the ICU C++ API.
%endif

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%python_sitelibdir/*
#%exclude %python_sitelibdir/*.egg-info
%doc CREDITS README* CHANGES samples/

%if_with python3
%files -n python3-module-%modulename
%python3_sitelibdir/*
#%exclude %python3_sitelibdir/*.egg-info
%doc CREDITS README* CHANGES samples/
%endif

%changelog
