%define oname igakit

%def_with python3

Name: python-module-%oname
Version: 0.1
Release: alt2.hg20150514.1.1
Summary: Toolkit for IsoGeometric Analysis (IGA)
License: BSD
Group: Development/Python
Url: https://petiga-igakit.readthedocs.org/en/latest/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# hg clone https://bitbucket.org/dalcinl/igakit
Source: %name-%version.tar

BuildPreReq: python-devel libnumpy-devel gcc-fortran
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel libnumpy-py3-devel
%endif

%description
igakit: Toolkit for IsoGeometric Analysis (IGA).

%package -n python3-module-%oname
Summary: Toolkit for IsoGeometric Analysis (IGA)
Group: Development/Python3

%description -n python3-module-%oname
igakit: Toolkit for IsoGeometric Analysis (IGA).

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%add_optflags %optflags_shared -fno-strict-aliasing
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
python setup.py build_ext -i
export PYTHONPATH=$PWD
%make testall
%if_with python3
pushd ../python3
python3 setup.py build_ext -i
export PYTHONPATH=$PWD
%make testall PYTHON=python3
popd
%endif

%files
%doc *.rst
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc *.rst
%python3_sitelibdir/*
%endif

%changelog
