%define modulename mwlib

Name: python-module-mwlib
Version: 0.15.14
Release: alt2

Summary: MediaWiki conversion library for Python
Group: Development/Python
License: BSD
Url: http://pypi.python.org/pypi/%modulename
Packager: Vitaly Lipatov <lav@altlinux.org>

# Source-url: https://pypi.python.org/packages/source/m/mwlib/mwlib-%version.zip
Source: %name-%version.tar
Patch: python-module-mwlib-0.15.14-alt-perl522.patch

BuildRequires: rpm-build-python

%setup_python_module %modulename

# Write manually:
BuildRequires: gcc-c++ re2c python-devel >= 2.5 python-module-docutils
BuildRequires: python-module-flup python-module-odfpy
BuildRequires: python-module-pyparsing python-module-simplejson python-module-imaging
BuildRequires: python-module-setuptools
Requires: python-module-twisted-core >= 8.2.0 python-module-twisted-web >= 8.2.0
Requires: python-module-flup >= 1.0 python-module-qserve

%description
mwlib is a Python library for parsing MediaWiki articles. It is
currently aimed at developers, who have a need to somehow handle
MediaWiki articles.

%define mwserve_log    %_logdir/mwserve
%define mwserve_cache  %_cachedir/mwserve
%define mwserve_piddir %_runtimedir/mwserve
%define mwserve_user   mwserve
%define mwserve_group  mwserve

%prep
%setup
%patch -p2

%build
export RST2HTML=rst2html
%python_build
%__make -C docs

%install
%python_install
install %modulename/__init__.* %buildroot%python_sitelibdir/%modulename/
#install daemon stuff
mkdir -p -- %buildroot/%_initdir %buildroot/%_sysconfdir/logrotate.d
mkdir -p -- %buildroot/%mwserve_log %buildroot/%mwserve_cache %buildroot/%mwserve_piddir
install -m 0755 -- mwserve.init %buildroot%_initdir/mwserve
install -m 0640 -- mwserve.logrotate %buildroot%_sysconfdir/logrotate.d/mwserve

%pre
# Add the "mwserve" user
%_sbindir/groupadd -r -f %mwserve_group 2>/dev/null ||:
%_sbindir/useradd  -r -g %mwserve_group -c 'mwlib server daemon' \
       -s /dev/null -d %mwserve_cache %mwserve_user 2>/dev/null ||:

%post
%post_service mwserve

%preun
%preun_service mwserve


%files
%doc README.txt docs/*.{txt,html}
%python_sitelibdir/mwlib*
%python_sitelibdir/argv.*
%_bindir/*
%config    %_initdir/mwserve
%attr(640,root,root) %config %_sysconfdir/logrotate.d/mwserve
%attr(0770,root,%mwserve_group) %dir %mwserve_log
%attr(0770,root,%mwserve_group) %dir %mwserve_cache
%attr(0770,root,%mwserve_group) %dir %mwserve_piddir


%changelog
