%define oname mysqlclient
%define fname python-module-%oname
%define descr \
mysqlclient is a fork of MySQL-python. It adds Python 3.3 support and \
merges some pull requests.

%def_enable check

Name: %fname
Version: 1.4.4
Release: alt1

%if ""==""
Summary: Python interface to MySQL
Group: Development/Python
%else
Summary: Documentation for %oname
Group: Development/Documentation
%endif

License: GPL
Url: https://pypi.python.org/pypi/mysqlclient/
# https://github.com/PyMySQL/mysqlclient-python.git
Source: %name-%version.tar

%if ""!=""
Conflicts: %fname < %EVR
Conflicts: %fname > %EVR
BuildArch: noarch
%else
Conflicts: python-module-MySQLdb
Conflicts: python-module-MySQLdb2
Provides: python-module-MySQLdb
%py_provides MySQLdb
%endif

BuildRequires(pre): rpm-macros-sphinx rpm-build-python
# Automatically added by buildreq on Thu Jan 28 2016 (-bi)
# optimized out: elfutils python-base python-devel python-module-PyStemmer python-module-Pygments python-module-babel python-module-cssselect python-module-genshi python-module-jinja2 python-module-jinja2-tests python-module-markupsafe python-module-pytz python-module-setuptools python-module-six python-module-snowballstemmer python-module-sphinx python-module-sphinx_rtd_theme python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-json python-modules-logging python-modules-multiprocessing python-modules-unittest python3 python3-base python3-module-setuptools
BuildRequires: libmysqlclient-devel python-module-alabaster python-module-docutils python-module-html5lib python-module-nose python-module-objects.inv python-module-pytest python3-devel python3-module-nose python3-module-pytest rpm-build-python3 time
BuildRequires: python-devel

%description
%descr

%if ""!=""
This package contains documentation for %oname.

%package -n %fname-pickles
Summary: Pickles for %oname
Group: Development/Python

%description -n %fname-pickles
%descr

This package contains pickles for %oname.
%endif

%prep
%setup
%if ""!=""
%prepare_sphinx .
ln -s ../objects.inv doc/
%endif

%build
%if ""==""
%python_build
%else
export PYTHONPATH=%buildroot%python_sitelibdir
%make -C doc pickle
%make -C doc html
%endif


%install
%if ""==""
%python_install
%else
install -d %buildroot%python_sitelibdir/%oname
cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%if ""==""
%check
python setup.py test

%files
%doc HISTORY* *.md
%python_sitelibdir/*

%else

%files
%doc doc/_build/html/*

%files -n %fname-pickles
%python_sitelibdir/*/pickle
%endif

%changelog
