%define oname nbconvert

%def_with python3
%def_without doc
%def_with bootstrap
%def_with check

Name: python-module-%oname
Version: 5.3.1
Release: alt5

Summary: Converting Jupyter Notebooks
License: BSD
Group: Development/Python

Url: https://pypi.python.org/pypi/nbconvert
# https://github.com/jupyter/nbconvert.git
Source: %name-%version.tar
# It may be necessary to update this file when package is updated
# https://cdn.jupyter.org/notebook/4.3.0/style/style.min.css
Source1: 4.3.0-style.min.css

BuildArch: noarch

BuildRequires(pre): rpm-macros-sphinx
BuildRequires: time
%if_with bootstrap
BuildRequires: python-module-ipython_genutils-tests python-module-notebook
%endif
BuildRequires: python-module-objects.inv python-module-pytest python-module-traitlets-tests
BuildRequires: python-module-pathlib2 python2.7(entrypoints) python2.7(bleach)
%if_with doc
BuildRequires: pandoc python-module-alabaster python-module-html5lib
BuildRequires: python2.7(sphinx_rtd_theme) python2.7(nbsphinx) python2.7(pandocfilters)
BuildRequires: texlive texlive-dist
%endif
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-jinja2-tests python3-module-traitlets-tests
%if_with doc
BuildRequires: python3-module-html5lib python3(pandocfilters)
%endif
%if_with bootstrap
BuildRequires: python3-module-ipython_genutils-tests python3-module-notebook
%endif
BuildRequires: python3-module-pathlib2 python3(entrypoints) python3(bleach)
%endif

# FIXME: with/enabled test/check to be strict
%if_with check
BuildRequires: python2.7(pandocfilters)
%if_with python3
BuildRequires: python3(pandocfilters)
%endif
%endif

%py_provides %oname
%py_requires mistune jinja2 pygments traitlets jupyter_core nbformat
%py_requires tornado jupyter_client

%description
Jupyter nbconvert converts notebooks to various other formats via Jinja
templates.

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
Jupyter nbconvert converts notebooks to various other formats via Jinja
templates.

This package contains tests for %oname.

%package -n python3-module-%oname
Summary: Converting Jupyter Notebooks
Group: Development/Python3
%py3_provides %oname
%py3_requires mistune jinja2 pygments traitlets jupyter_core nbformat
%py3_requires tornado jupyter_client

%description -n python3-module-%oname
Jupyter nbconvert converts notebooks to various other formats via Jinja
templates.

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
Jupyter nbconvert converts notebooks to various other formats via Jinja
templates.

This package contains tests for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
Jupyter nbconvert converts notebooks to various other formats via Jinja
templates.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Jupyter nbconvert converts notebooks to various other formats via Jinja
templates.

This package contains documentation for %oname.

%prep
%setup

# This is intentionally set up to fail if version of required file changes.
# In case of such failure it's required to obtain a new version of file.
cp %SOURCE1 nbconvert/resources/
resource_version=$(grep '^notebook_css_version' setup.py | awk '{print $3}' | xargs echo)
mv nbconvert/resources/${resource_version}-style.min.css nbconvert/resources/style.min.css

%if_with python3
cp -fR . ../python3
%endif

%if_with doc
%prepare_sphinx docs
ln -s ../objects.inv docs/source/
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done
popd
%endif

%python_install

%if_with doc
export PYTHONPATH=$PWD
export PATH=$PATH:%buildroot%_bindir
%make -C docs pickle
%make -C docs html
cp -fR docs/build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%if_with bootstrap
%check
export LC_ALL=en_US.UTF-8
PYTHONPATH=$(pwd) py.test -vv
%if_with python3
pushd ../python3
PYTHONPATH=$(pwd) py.test3 -vv
popd
%endif
%endif

%files
%doc *.md
%_bindir/*
%if_with python3
%exclude %_bindir/*.py3
%endif
%python_sitelibdir/*
%if_with doc
%exclude %python_sitelibdir/*/pickle
%endif
%exclude %python_sitelibdir/*/tests
%exclude %python_sitelibdir/*/*/tests

%files tests
%python_sitelibdir/*/tests
%python_sitelibdir/*/*/tests

%if_with doc
%files pickles
%python_sitelibdir/*/pickle

%files docs
%doc docs/build/html/*
%endif

%if_with python3
%files -n python3-module-%oname
%doc *.md
%_bindir/*.py3
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/*/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/*/*/tests
%endif

%changelog
