%define version 3.2.1
%define release alt1
%define oname nltk

%def_with python3

%setup_python_module %oname

Name: python-module-%oname
Summary: Python modules for Natural Language Processing (NLP)
Group: Development/Python
Version: %version
Release: alt1
License: Apache
Url: http://www.nltk.org
BuildRequires(pre): rpm-build-python
BuildArch: noarch
Packager: Kirill Maslinsky <kirill@altlinux.org>

Source: %name-%version.tar

# Automatically added by buildreq on Fri Jan 29 2016 (-bi)
# optimized out: fontconfig python-base python-devel python-module-numpy python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-logging python-modules-unittest python-modules-xml python-tools-2to3 python3 python3-base python3-module-numpy
BuildRequires: python-module-numpy-testing python-module-setuptools python-module-yaml python-modules-json python-modules-tkinter python3-module-numpy-testing python3-module-setuptools python3-module-yaml rpm-build-python3 time

#BuildPreReq: python-module-setuptools python-modules-json
%if_with python3
BuildRequires(pre): rpm-build-python3
#BuildPreReq: python3-devel python3-module-numpy
#BuildPreReq: python3-module-yaml
#BuildPreReq: python3-module-setuptools python-tools-2to3
%endif

%add_python_req_skip twython

%description
Description: The Natural Language Toolkit (NLTK) is a Python package for
processing natural language text.  NLTK requires Python 2.4 or higher.

Keywords: NLP,CL,natural language processing,computational
linguistics,parsing,tagging,tokenizing,syntax,linguistics,language,natural
language

%package -n python3-module-%oname
Summary: Python modules for Natural Language Processing (NLP)
Group: Development/Python3
%add_python3_req_skip twython

%description -n python3-module-%oname
Description: The Natural Language Toolkit (NLTK) is a Python package for
processing natural language text.  NLTK requires Python 2.4 or higher.

Keywords: NLP,CL,natural language processing,computational
linguistics,parsing,tagging,tokenizing,syntax,linguistics,language,natural
language

%package tests
Summary: Tests for NLTK
Group: Development/Python
Requires: %name = %EVR
%add_python_req_skip featurechart twython
#treeview align_util distance_measures

%description tests
Description: The Natural Language Toolkit (NLTK) is a Python package for
processing natural language text.  NLTK requires Python 2.4 or higher.

Keywords: NLP,CL,natural language processing,computational
linguistics,parsing,tagging,tokenizing,syntax,linguistics,language,natural
language

This package contains teets for NLTK.

%package -n python3-module-%oname-tests
Summary: Tests for NLTK
Group: Development/Python3
Requires: python3-module-%oname = %EVR
%add_python3_req_skip featurechart twython
#treeview

%description -n python3-module-%oname-tests
Description: The Natural Language Toolkit (NLTK) is a Python package for
processing natural language text.  NLTK requires Python 2.4 or higher.

Keywords: NLP,CL,natural language processing,computational
linguistics,parsing,tagging,tokenizing,syntax,linguistics,language,natural
language

This package contains teets for NLTK.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

echo 'from Tkinter import *' >%buildroot%python_sitelibdir/tkinter.py

%files
%python_sitelibdir/tkinter.py*
%python_sitelibdir/nltk/
%python_sitelibdir/*.egg-info
%doc LICENSE.txt
%exclude %python_sitelibdir/*/test

%files tests
%python_sitelibdir/*/test

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/nltk
%python3_sitelibdir/*.egg-info
%doc LICENSE.txt
%exclude %python3_sitelibdir/*/test

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/test
%endif

%changelog
