%define modulename PyBluez

%def_with python3

Name: python-module-pybluez
Version: 0.20
Release: alt1.1.1
Summary: A Python module for the Bluez library
Group: Development/Python
License: GPL
Url: http://code.google.com/p/pybluez/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: libbluez >= 4.0

Source: %url/files/%modulename-%version.tar.gz

BuildRequires: libbluez-devel python-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
%endif

%description
PyBluez is an effort to create python wrappers around bluez to allow python
developers to use system bluetooth resources.

%setup_python_module %modulename

%package -n python3-module-pybluez
Summary: A Python module for the Bluez library
Group: Development/Python3

%description -n python3-module-pybluez
PyBluez is an effort to create python wrappers around bluez to allow python
developers to use system bluetooth resources.

%prep
%setup -n %modulename-%version

%if_with python3
cp -fR . ../python3
%endif

%build
%add_optflags -fno-strict-aliasing
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc README CHANGELOG COPYING PKG-INFO
%python_sitelibdir/bluetooth
%python_sitelibdir/*.egg-info
%exclude %python_sitelibdir/bluetooth/msbt*
%exclude %python_sitelibdir/bluetooth/widcomm*

%if_with python3
%files -n python3-module-pybluez
%doc README CHANGELOG COPYING PKG-INFO
%python3_sitelibdir/bluetooth
%python3_sitelibdir/*.egg-info
%exclude %python3_sitelibdir/bluetooth/msbt*
%exclude %python3_sitelibdir/bluetooth/widcomm*
%endif

%changelog
