%define _unpackaged_files_terminate_build 1
%define oname pyflakes

%def_with check

Name: python-module-%oname
Version: 2.1.1
Release: alt1

Summary: A simple program which checks Python source files for errors
License: MIT
Group: Development/Python

Url: https://pypi.python.org/pypi/pyflakes
# https://github.com/PyCQA/pyflakes.git
Source: %name-%version.tar
Source1: pyflakes.1

BuildArch: noarch
BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python2.7(json)
BuildRequires: python3(tox)
%endif

Provides: pyflakes = %EVR
Obsoletes: pyflakes < %EVR

%description
Pyflakes is similar to PyChecker in scope, but differs in that it does\
not execute the modules to check them. This is both safer and faster,\
although it does not perform as many checks. Unlike PyLint, Pyflakes\
checks only for logical errors in programs; it does not perform any\
check on style.

%package -n python3-module-%oname
Summary: A simple program which checks Python source files for errors
Group: Development/Python3
Provides: python3-pyflakes = %EVR
Obsoletes: python3-pyflakes < %EVR

%description -n python3-module-%oname
Pyflakes is similar to PyChecker in scope, but differs in that it does\
not execute the modules to check them. This is both safer and faster,\
although it does not perform as many checks. Unlike PyLint, Pyflakes\
checks only for logical errors in programs; it does not perform any\
check on style.

%prep
%setup

rm -rf ../python3
cp -a . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
pushd ../python3
install -Dpm 644 %SOURCE1 %buildroot%_man1dir/python3-pyflakes.1
%python3_install

mv %buildroot%_bindir/{pyflakes,python3-pyflakes}
# don't package tests
rm -r %buildroot%python3_sitelibdir/pyflakes/test
popd

install -Dpm 644 %SOURCE1 %buildroot%_man1dir/pyflakes.1
%python_install
rm -r %buildroot%python_sitelibdir/pyflakes/test

%check
# we don't want flake8, because pyflakes is its dep
sed -i \
-e "/deps = flake8/d" \
-e "/flake8 pyflakes setup.py/d" \
tox.ini

export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python},py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -v

%files
%doc AUTHORS LICENSE README.rst
%_man1dir/pyflakes.1*
%_bindir/pyflakes
%python_sitelibdir/pyflakes/
%python_sitelibdir/pyflakes-*.egg-info/

%files -n python3-module-%oname
%doc AUTHORS LICENSE README.rst
%_man1dir/python3-pyflakes.1*
%_bindir/python3-pyflakes
%python3_sitelibdir/pyflakes/
%python3_sitelibdir/pyflakes-*.egg-info/

%changelog
